/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.client.impl;

import com.atlassian.nutcluster.client.impl.ClientEndpoint;
import com.atlassian.nutcluster.client.impl.ClientEngine;
import com.atlassian.nutcluster.client.impl.client.ClientPrincipal;
import com.atlassian.nutcluster.core.ClientType;
import com.atlassian.nutcluster.core.NutclusterInstanceNotActiveException;
import com.atlassian.nutcluster.instance.BuildInfo;
import com.atlassian.nutcluster.logging.ILogger;
import com.atlassian.nutcluster.nio.Connection;
import com.atlassian.nutcluster.nio.ConnectionType;
import com.atlassian.nutcluster.nio.tcp.TcpIpConnection;
import com.atlassian.nutcluster.security.Credentials;
import com.atlassian.nutcluster.spi.EventService;
import com.atlassian.nutcluster.spi.impl.NodeEngineImpl;
import com.atlassian.nutcluster.transaction.TransactionContext;
import com.atlassian.nutcluster.transaction.TransactionException;
import com.atlassian.nutcluster.transaction.impl.xa.XATransactionContextImpl;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;

public final class ClientEndpointImpl
implements ClientEndpoint {
    private final ClientEngine clientEngine;
    private final ILogger logger;
    private final NodeEngineImpl nodeEngine;
    private final Connection connection;
    private final ConcurrentMap<String, TransactionContext> transactionContextMap = new ConcurrentHashMap<String, TransactionContext>();
    private final ConcurrentMap<String, Callable> removeListenerActions = new ConcurrentHashMap<String, Callable>();
    private final SocketAddress socketAddress;
    private final long creationTime;
    private LoginContext loginContext;
    private ClientPrincipal principal;
    private boolean ownerConnection;
    private Credentials credentials;
    private volatile boolean authenticated;
    private int clientVersion;
    private String clientVersionString;
    private long authenticationCorrelationId;
    private volatile String stats;
    private String clientName;
    private Set<String> labels;
    private volatile boolean destroyed;

    public ClientEndpointImpl(ClientEngine clientEngine, NodeEngineImpl nodeEngine, Connection connection) {
        this.clientEngine = clientEngine;
        this.logger = clientEngine.getLogger(this.getClass());
        this.nodeEngine = nodeEngine;
        this.connection = connection;
        if (connection instanceof TcpIpConnection) {
            TcpIpConnection tcpIpConnection = (TcpIpConnection)connection;
            this.socketAddress = tcpIpConnection.getRemoteSocketAddress();
        } else {
            this.socketAddress = null;
        }
        this.clientVersion = -1;
        this.clientVersionString = "Unknown";
        this.creationTime = System.currentTimeMillis();
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public String getUuid() {
        return this.principal != null ? this.principal.getUuid() : null;
    }

    @Override
    public boolean isAlive() {
        return this.connection.isAlive();
    }

    @Override
    public void setLoginContext(LoginContext loginContext) {
        this.loginContext = loginContext;
    }

    @Override
    public Subject getSubject() {
        return this.loginContext != null ? this.loginContext.getSubject() : null;
    }

    @Override
    public boolean isOwnerConnection() {
        return this.ownerConnection;
    }

    @Override
    public void authenticated(ClientPrincipal principal, Credentials credentials, boolean firstConnection, String clientVersion, long authCorrelationId, String clientName, Set<String> labels) {
        this.principal = principal;
        this.ownerConnection = firstConnection;
        this.credentials = credentials;
        this.authenticated = true;
        this.authenticationCorrelationId = authCorrelationId;
        this.setClientVersion(clientVersion);
        this.clientName = clientName;
        this.labels = labels;
    }

    @Override
    public void authenticated(ClientPrincipal principal) {
        this.principal = principal;
        this.authenticated = true;
    }

    @Override
    public boolean isAuthenticated() {
        return this.authenticated;
    }

    @Override
    public int getClientVersion() {
        return this.clientVersion;
    }

    @Override
    public void setClientVersion(String version) {
        this.clientVersionString = version;
        this.clientVersion = BuildInfo.calculateVersion(version);
    }

    @Override
    public void setClientStatistics(String stats) {
        this.stats = stats;
    }

    @Override
    public String getClientStatistics() {
        return this.stats;
    }

    @Override
    public InetSocketAddress getSocketAddress() {
        return (InetSocketAddress)this.socketAddress;
    }

    @Override
    public ClientType getClientType() {
        return switch (this.connection.getType()) {
            case ConnectionType.JAVA_CLIENT -> ClientType.JAVA;
            case ConnectionType.CSHARP_CLIENT -> ClientType.CSHARP;
            case ConnectionType.CPP_CLIENT -> ClientType.CPP;
            case ConnectionType.PYTHON_CLIENT -> ClientType.PYTHON;
            case ConnectionType.RUBY_CLIENT -> ClientType.RUBY;
            case ConnectionType.NODEJS_CLIENT -> ClientType.NODEJS;
            case ConnectionType.GO_CLIENT -> ClientType.GO;
            case ConnectionType.BINARY_CLIENT -> ClientType.OTHER;
            default -> throw new IllegalArgumentException("Invalid connection type: " + String.valueOf((Object)this.connection.getType()));
        };
    }

    @Override
    public String getName() {
        return this.clientName;
    }

    @Override
    public Set<String> getLabels() {
        return this.labels;
    }

    @Override
    public TransactionContext getTransactionContext(String txnId) {
        TransactionContext transactionContext = (TransactionContext)this.transactionContextMap.get(txnId);
        if (transactionContext == null) {
            throw new TransactionException("No transaction context found for txnId:" + txnId);
        }
        return transactionContext;
    }

    @Override
    public Credentials getCredentials() {
        return this.credentials;
    }

    @Override
    public void setTransactionContext(TransactionContext transactionContext) {
        this.transactionContextMap.put(transactionContext.getTxnId(), transactionContext);
        if (this.destroyed) {
            this.removedAndRollbackTransactionContext(transactionContext.getTxnId());
        }
    }

    @Override
    public void removeTransactionContext(String txnId) {
        this.transactionContextMap.remove(txnId);
    }

    @Override
    public void addListenerDestroyAction(final String service, final String topic, final String id) {
        final EventService eventService = this.clientEngine.getEventService();
        this.addDestroyAction(id, new Callable<Boolean>(){

            @Override
            public Boolean call() {
                return eventService.deregisterListener(service, topic, id);
            }
        });
    }

    @Override
    public void addDestroyAction(String registrationId, Callable<Boolean> removeAction) {
        this.removeListenerActions.put(registrationId, removeAction);
        if (this.destroyed) {
            this.removeAndCallRemoveAction(registrationId);
        }
    }

    @Override
    public boolean removeDestroyAction(String id) {
        return this.removeListenerActions.remove(id) != null;
    }

    @Override
    public void clearAllListeners() {
        for (String registrationId : this.removeListenerActions.keySet()) {
            this.removeAndCallRemoveAction(registrationId);
        }
    }

    public void destroy() throws LoginException {
        this.destroyed = true;
        this.nodeEngine.onClientDisconnected(this.getUuid());
        this.clearAllListeners();
        for (String txnId : this.transactionContextMap.keySet()) {
            this.removedAndRollbackTransactionContext(txnId);
        }
        try {
            LoginContext lc = this.loginContext;
            if (lc != null) {
                lc.logout();
            }
        }
        finally {
            this.authenticated = false;
        }
    }

    private void removeAndCallRemoveAction(String uuid) {
        Callable callable = (Callable)this.removeListenerActions.remove(uuid);
        if (callable != null) {
            try {
                callable.call();
            }
            catch (Exception e) {
                this.logger.warning("Exception during remove listener action", e);
            }
        }
    }

    private void removedAndRollbackTransactionContext(String txnId) {
        TransactionContext context = (TransactionContext)this.transactionContextMap.remove(txnId);
        if (context != null) {
            if (context instanceof XATransactionContextImpl) {
                return;
            }
            try {
                context.rollbackTransaction();
            }
            catch (NutclusterInstanceNotActiveException e) {
                this.logger.finest(e);
            }
            catch (Exception e) {
                this.logger.warning(e);
            }
        }
    }

    public String toString() {
        return "ClientEndpoint{connection=" + String.valueOf(this.connection) + ", principal='" + String.valueOf(this.principal) + ", ownerConnection=" + this.ownerConnection + ", authenticated=" + this.authenticated + ", clientVersion=" + this.clientVersionString + ", creationTime=" + this.creationTime + ", latest statistics=" + this.stats + "}";
    }

    public long getAuthenticationCorrelationId() {
        return this.authenticationCorrelationId;
    }
}

