/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.client.impl.protocol;

import com.atlassian.nutcluster.cache.CacheNotExistsException;
import com.atlassian.nutcluster.client.impl.StubAuthenticationException;
import com.atlassian.nutcluster.client.impl.protocol.ClientMessage;
import com.atlassian.nutcluster.client.impl.protocol.codec.ErrorCodec;
import com.atlassian.nutcluster.client.impl.protocol.exception.MaxMessageSizeExceeded;
import com.atlassian.nutcluster.config.ConfigurationException;
import com.atlassian.nutcluster.config.InvalidConfigurationException;
import com.atlassian.nutcluster.core.ConsistencyLostException;
import com.atlassian.nutcluster.core.DuplicateInstanceNameException;
import com.atlassian.nutcluster.core.IndeterminateOperationStateException;
import com.atlassian.nutcluster.core.LocalMemberResetException;
import com.atlassian.nutcluster.core.MemberLeftException;
import com.atlassian.nutcluster.core.NutclusterException;
import com.atlassian.nutcluster.core.NutclusterInstanceNotActiveException;
import com.atlassian.nutcluster.core.NutclusterOverloadException;
import com.atlassian.nutcluster.core.OperationTimeoutException;
import com.atlassian.nutcluster.cp.exception.CPGroupDestroyedException;
import com.atlassian.nutcluster.cp.exception.CannotReplicateException;
import com.atlassian.nutcluster.cp.exception.LeaderDemotedException;
import com.atlassian.nutcluster.cp.exception.NotLeaderException;
import com.atlassian.nutcluster.cp.exception.StaleAppendRequestException;
import com.atlassian.nutcluster.cp.internal.datastructures.exception.WaitKeyCancelledException;
import com.atlassian.nutcluster.cp.internal.session.SessionExpiredException;
import com.atlassian.nutcluster.cp.lock.exception.LockAcquireLimitReachedException;
import com.atlassian.nutcluster.cp.lock.exception.LockOwnershipLostException;
import com.atlassian.nutcluster.crdt.MutationDisallowedException;
import com.atlassian.nutcluster.crdt.TargetNotReplicaException;
import com.atlassian.nutcluster.durableexecutor.StaleTaskIdException;
import com.atlassian.nutcluster.flakeidgen.impl.NodeIdOutOfRangeException;
import com.atlassian.nutcluster.internal.cluster.impl.ConfigMismatchException;
import com.atlassian.nutcluster.map.QueryResultSizeExceededException;
import com.atlassian.nutcluster.map.ReachedMaxSizeException;
import com.atlassian.nutcluster.mapreduce.RemoteMapReduceException;
import com.atlassian.nutcluster.mapreduce.TopologyChangedException;
import com.atlassian.nutcluster.memory.NativeOutOfMemoryError;
import com.atlassian.nutcluster.nio.serialization.NutclusterSerializationException;
import com.atlassian.nutcluster.partition.NoDataMemberInClusterException;
import com.atlassian.nutcluster.query.QueryException;
import com.atlassian.nutcluster.quorum.QuorumException;
import com.atlassian.nutcluster.replicatedmap.ReplicatedMapCantBeCreatedOnLiteMemberException;
import com.atlassian.nutcluster.ringbuffer.StaleSequenceException;
import com.atlassian.nutcluster.scheduledexecutor.DuplicateTaskException;
import com.atlassian.nutcluster.scheduledexecutor.StaleTaskException;
import com.atlassian.nutcluster.spi.exception.CallerNotMemberException;
import com.atlassian.nutcluster.spi.exception.DistributedObjectDestroyedException;
import com.atlassian.nutcluster.spi.exception.PartitionMigratingException;
import com.atlassian.nutcluster.spi.exception.ResponseAlreadySentException;
import com.atlassian.nutcluster.spi.exception.RetryableIOException;
import com.atlassian.nutcluster.spi.exception.RetryableNutclusterException;
import com.atlassian.nutcluster.spi.exception.ServiceNotFoundException;
import com.atlassian.nutcluster.spi.exception.TargetDisconnectedException;
import com.atlassian.nutcluster.spi.exception.TargetNotMemberException;
import com.atlassian.nutcluster.spi.exception.WrongTargetException;
import com.atlassian.nutcluster.topic.TopicOverloadException;
import com.atlassian.nutcluster.transaction.TransactionException;
import com.atlassian.nutcluster.transaction.TransactionNotActiveException;
import com.atlassian.nutcluster.transaction.TransactionTimedOutException;
import com.atlassian.nutcluster.util.AddressUtil;
import com.atlassian.nutcluster.wan.WANReplicationQueueFullException;
import java.io.EOFException;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.UTFDataFormatException;
import java.net.SocketException;
import java.net.URISyntaxException;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeoutException;
import javax.cache.CacheException;
import javax.cache.integration.CacheLoaderException;
import javax.cache.integration.CacheWriterException;
import javax.cache.processor.EntryProcessorException;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.transaction.xa.XAException;

public class ClientExceptions {
    private static final String CAUSED_BY_STACKTRACE_MARKER = "###### Caused by:";
    private final Map<Class, Integer> classToInt = new HashMap<Class, Integer>();

    public ClientExceptions(boolean jcacheAvailable) {
        if (jcacheAvailable) {
            this.register(4, CacheException.class);
            this.register(5, CacheLoaderException.class);
            this.register(7, CacheWriterException.class);
            this.register(18, EntryProcessorException.class);
        }
        this.register(1, ArrayIndexOutOfBoundsException.class);
        this.register(2, ArrayStoreException.class);
        this.register(3, StubAuthenticationException.class);
        this.register(6, CacheNotExistsException.class);
        this.register(8, CallerNotMemberException.class);
        this.register(9, CancellationException.class);
        this.register(10, ClassCastException.class);
        this.register(11, ClassNotFoundException.class);
        this.register(12, ConcurrentModificationException.class);
        this.register(13, ConfigMismatchException.class);
        this.register(14, ConfigurationException.class);
        this.register(15, DistributedObjectDestroyedException.class);
        this.register(16, DuplicateInstanceNameException.class);
        this.register(17, EOFException.class);
        this.register(19, ExecutionException.class);
        this.register(20, NutclusterException.class);
        this.register(21, NutclusterInstanceNotActiveException.class);
        this.register(22, NutclusterOverloadException.class);
        this.register(23, NutclusterSerializationException.class);
        this.register(24, IOException.class);
        this.register(25, IllegalArgumentException.class);
        this.register(26, IllegalAccessException.class);
        this.register(27, IllegalAccessError.class);
        this.register(28, IllegalMonitorStateException.class);
        this.register(29, IllegalStateException.class);
        this.register(30, IllegalThreadStateException.class);
        this.register(31, IndexOutOfBoundsException.class);
        this.register(32, InterruptedException.class);
        this.register(33, AddressUtil.InvalidAddressException.class);
        this.register(34, InvalidConfigurationException.class);
        this.register(35, MemberLeftException.class);
        this.register(36, NegativeArraySizeException.class);
        this.register(37, NoSuchElementException.class);
        this.register(38, NotSerializableException.class);
        this.register(39, NullPointerException.class);
        this.register(40, OperationTimeoutException.class);
        this.register(41, PartitionMigratingException.class);
        this.register(42, QueryException.class);
        this.register(43, QueryResultSizeExceededException.class);
        this.register(44, QuorumException.class);
        this.register(45, ReachedMaxSizeException.class);
        this.register(46, RejectedExecutionException.class);
        this.register(47, RemoteMapReduceException.class);
        this.register(48, ResponseAlreadySentException.class);
        this.register(49, RetryableNutclusterException.class);
        this.register(50, RetryableIOException.class);
        this.register(51, RuntimeException.class);
        this.register(52, SecurityException.class);
        this.register(53, SocketException.class);
        this.register(54, StaleSequenceException.class);
        this.register(55, TargetDisconnectedException.class);
        this.register(56, TargetNotMemberException.class);
        this.register(57, TimeoutException.class);
        this.register(58, TopicOverloadException.class);
        this.register(59, TopologyChangedException.class);
        this.register(60, TransactionException.class);
        this.register(61, TransactionNotActiveException.class);
        this.register(62, TransactionTimedOutException.class);
        this.register(63, URISyntaxException.class);
        this.register(64, UTFDataFormatException.class);
        this.register(65, UnsupportedOperationException.class);
        this.register(66, WrongTargetException.class);
        this.register(67, XAException.class);
        this.register(68, AccessControlException.class);
        this.register(69, LoginException.class);
        this.register(70, UnsupportedCallbackException.class);
        this.register(71, NoDataMemberInClusterException.class);
        this.register(72, ReplicatedMapCantBeCreatedOnLiteMemberException.class);
        this.register(73, MaxMessageSizeExceeded.class);
        this.register(74, WANReplicationQueueFullException.class);
        this.register(75, AssertionError.class);
        this.register(76, OutOfMemoryError.class);
        this.register(77, StackOverflowError.class);
        this.register(78, NativeOutOfMemoryError.class);
        this.register(79, ServiceNotFoundException.class);
        this.register(80, StaleTaskIdException.class);
        this.register(81, DuplicateTaskException.class);
        this.register(82, StaleTaskException.class);
        this.register(83, LocalMemberResetException.class);
        this.register(84, IndeterminateOperationStateException.class);
        this.register(85, NodeIdOutOfRangeException.class);
        this.register(86, TargetNotReplicaException.class);
        this.register(87, MutationDisallowedException.class);
        this.register(88, ConsistencyLostException.class);
        this.register(89, SessionExpiredException.class);
        this.register(90, WaitKeyCancelledException.class);
        this.register(91, LockAcquireLimitReachedException.class);
        this.register(92, LockOwnershipLostException.class);
        this.register(93, CPGroupDestroyedException.class);
        this.register(94, CannotReplicateException.class);
        this.register(95, LeaderDemotedException.class);
        this.register(96, StaleAppendRequestException.class);
        this.register(97, NotLeaderException.class);
        this.register(98, NoSuchMethodError.class);
        this.register(99, NoSuchMethodException.class);
        this.register(100, NoSuchFieldError.class);
        this.register(101, NoSuchFieldException.class);
        this.register(102, NoClassDefFoundError.class);
    }

    public ClientMessage createExceptionMessage(Throwable throwable) {
        String causeClassName;
        int causeErrorCode;
        int errorCode = this.getErrorCode(throwable);
        String message = throwable.getMessage();
        ArrayList<StackTraceElement> combinedStackTrace = new ArrayList<StackTraceElement>();
        Throwable t = throwable;
        while (t != null) {
            combinedStackTrace.addAll(Arrays.asList(t.getStackTrace()));
            if ((t = t.getCause()) == null) continue;
            String throwableToString = t.getClass().getName() + (String)(t.getLocalizedMessage() != null ? ": " + t.getLocalizedMessage() : "");
            combinedStackTrace.add(new StackTraceElement("###### Caused by: (" + this.getErrorCode(t) + ") " + throwableToString + " ------", "", null, -1));
        }
        Throwable cause = throwable.getCause();
        if (cause != null) {
            causeErrorCode = this.getErrorCode(cause);
            causeClassName = cause.getClass().getName();
        } else {
            causeErrorCode = 0;
            causeClassName = null;
        }
        StackTraceElement[] combinedStackTraceArray = combinedStackTrace.toArray(new StackTraceElement[combinedStackTrace.size()]);
        return ErrorCodec.encode(errorCode, throwable.getClass().getName(), message, combinedStackTraceArray, causeErrorCode, causeClassName);
    }

    public void register(int errorCode, Class clazz) {
        Integer currentCode = this.classToInt.get(clazz);
        if (currentCode != null) {
            throw new NutclusterException("Class " + clazz.getName() + " already added with code: " + currentCode);
        }
        this.classToInt.put(clazz, errorCode);
    }

    private int getErrorCode(Throwable e) {
        Integer errorCode = this.classToInt.get(e.getClass());
        if (errorCode == null) {
            return 0;
        }
        return errorCode;
    }

    boolean isKnownClass(Class<? extends Throwable> aClass) {
        return this.classToInt.containsKey(aClass);
    }
}

