/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.client.impl.protocol.codec;

import com.atlassian.nutcluster.client.impl.protocol.ClientMessage;
import com.atlassian.nutcluster.client.impl.protocol.codec.CPSessionMessageType;
import com.atlassian.nutcluster.client.impl.protocol.codec.RaftGroupIdCodec;
import com.atlassian.nutcluster.cp.internal.RaftGroupId;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;

@SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
public final class CPSessionHeartbeatSessionCodec {
    public static final CPSessionMessageType REQUEST_TYPE = CPSessionMessageType.CPSESSION_HEARTBEATSESSION;
    public static final int RESPONSE_TYPE = 100;

    public static ClientMessage encodeRequest(RaftGroupId groupId, long sessionId) {
        int requiredDataSize = RequestParameters.calculateDataSize(groupId, sessionId);
        ClientMessage clientMessage = ClientMessage.createForEncode(requiredDataSize);
        clientMessage.setMessageType(REQUEST_TYPE.id());
        clientMessage.setRetryable(true);
        clientMessage.setAcquiresResource(false);
        clientMessage.setOperationName("CPSession.heartbeatSession");
        RaftGroupIdCodec.encode(groupId, clientMessage);
        clientMessage.set(sessionId);
        clientMessage.updateFrameLength();
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        RequestParameters parameters = new RequestParameters();
        if (clientMessage.isComplete()) {
            return parameters;
        }
        RaftGroupId groupId = null;
        parameters.groupId = groupId = RaftGroupIdCodec.decode(clientMessage);
        long sessionId = 0L;
        parameters.sessionId = sessionId = clientMessage.getLong();
        return parameters;
    }

    public static ClientMessage encodeResponse() {
        int requiredDataSize = ResponseParameters.calculateDataSize();
        ClientMessage clientMessage = ClientMessage.createForEncode(requiredDataSize);
        clientMessage.setMessageType(100);
        clientMessage.updateFrameLength();
        return clientMessage;
    }

    public static ResponseParameters decodeResponse(ClientMessage clientMessage) {
        ResponseParameters parameters = new ResponseParameters();
        return parameters;
    }

    public static class RequestParameters {
        public static final CPSessionMessageType TYPE = REQUEST_TYPE;
        public RaftGroupId groupId;
        public long sessionId;

        public static int calculateDataSize(RaftGroupId groupId, long sessionId) {
            int dataSize = ClientMessage.HEADER_SIZE;
            dataSize += RaftGroupIdCodec.calculateDataSize(groupId);
            return dataSize += 8;
        }
    }

    public static class ResponseParameters {
        public static int calculateDataSize() {
            int dataSize = ClientMessage.HEADER_SIZE;
            return dataSize;
        }
    }
}

