/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.client.impl.protocol.codec;

import com.atlassian.nutcluster.client.impl.protocol.ClientMessage;
import com.atlassian.nutcluster.client.impl.protocol.codec.AddressCodec;
import com.atlassian.nutcluster.client.impl.protocol.util.ParameterUtil;
import com.atlassian.nutcluster.mapreduce.JobPartitionState;
import com.atlassian.nutcluster.mapreduce.impl.task.JobPartitionStateImpl;
import com.atlassian.nutcluster.nio.Address;

public final class JobPartitionStateCodec {
    private JobPartitionStateCodec() {
    }

    public static JobPartitionState decode(ClientMessage clientMessage) {
        Address address = AddressCodec.decode(clientMessage);
        String state = clientMessage.getStringUtf8();
        return new JobPartitionStateImpl(address, JobPartitionState.State.valueOf(state));
    }

    public static void encode(JobPartitionState jobPartitionState, ClientMessage clientMessage) {
        AddressCodec.encode(jobPartitionState.getOwner(), clientMessage);
        clientMessage.set(jobPartitionState.getState().name());
    }

    public static int calculateDataSize(JobPartitionState jobPartitionState) {
        int dataSize = AddressCodec.calculateDataSize(jobPartitionState.getOwner());
        return dataSize += ParameterUtil.calculateDataSize(jobPartitionState.getState().name());
    }
}

