/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.client.impl.protocol.task.dynamicconfig;

import com.atlassian.nutcluster.client.impl.protocol.ClientMessage;
import com.atlassian.nutcluster.client.impl.protocol.codec.DynamicConfigAddMerkleTreeConfigCodec;
import com.atlassian.nutcluster.client.impl.protocol.task.dynamicconfig.AbstractAddConfigMessageTask;
import com.atlassian.nutcluster.config.MerkleTreeConfig;
import com.atlassian.nutcluster.instance.Node;
import com.atlassian.nutcluster.internal.dynamicconfig.DynamicConfigurationAwareConfig;
import com.atlassian.nutcluster.nio.Connection;
import com.atlassian.nutcluster.nio.serialization.IdentifiedDataSerializable;
import com.atlassian.nutcluster.util.Preconditions;

public class AddMerkleTreeConfigMessageTask
extends AbstractAddConfigMessageTask<DynamicConfigAddMerkleTreeConfigCodec.RequestParameters> {
    public AddMerkleTreeConfigMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected DynamicConfigAddMerkleTreeConfigCodec.RequestParameters decodeClientMessage(ClientMessage clientMessage) {
        return DynamicConfigAddMerkleTreeConfigCodec.decodeRequest(clientMessage);
    }

    @Override
    protected ClientMessage encodeResponse(Object response) {
        return DynamicConfigAddMerkleTreeConfigCodec.encodeResponse();
    }

    @Override
    protected IdentifiedDataSerializable getConfig() {
        Preconditions.checkHasText(((DynamicConfigAddMerkleTreeConfigCodec.RequestParameters)this.parameters).mapName, "Merkle tree config must define a map name");
        return new MerkleTreeConfig().setMapName(((DynamicConfigAddMerkleTreeConfigCodec.RequestParameters)this.parameters).mapName).setEnabled(((DynamicConfigAddMerkleTreeConfigCodec.RequestParameters)this.parameters).enabled).setDepth(((DynamicConfigAddMerkleTreeConfigCodec.RequestParameters)this.parameters).depth);
    }

    @Override
    protected boolean checkStaticConfigDoesNotExist(IdentifiedDataSerializable config) {
        DynamicConfigurationAwareConfig nodeConfig = (DynamicConfigurationAwareConfig)this.nodeEngine.getConfig();
        MerkleTreeConfig merkleTreeConfig = (MerkleTreeConfig)config;
        return nodeConfig.checkStaticConfigDoesNotExist(nodeConfig.getStaticConfig().getMapMerkleTreeConfigs(), merkleTreeConfig.getMapName(), merkleTreeConfig);
    }

    @Override
    public String getMethodName() {
        return "addMerkleTreeConfig";
    }
}

