/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.client.impl.protocol.task.map;

import com.atlassian.nutcluster.client.impl.protocol.ClientMessage;
import com.atlassian.nutcluster.client.impl.protocol.codec.MapFetchWithQueryCodec;
import com.atlassian.nutcluster.client.impl.protocol.task.map.AbstractMapPartitionMessageTask;
import com.atlassian.nutcluster.instance.Node;
import com.atlassian.nutcluster.map.impl.operation.MapOperationProvider;
import com.atlassian.nutcluster.map.impl.query.Query;
import com.atlassian.nutcluster.map.impl.query.QueryResult;
import com.atlassian.nutcluster.map.impl.query.QueryResultRow;
import com.atlassian.nutcluster.map.impl.query.ResultSegment;
import com.atlassian.nutcluster.nio.Connection;
import com.atlassian.nutcluster.nio.serialization.Data;
import com.atlassian.nutcluster.projection.Projection;
import com.atlassian.nutcluster.query.Predicate;
import com.atlassian.nutcluster.security.permission.MapPermission;
import com.atlassian.nutcluster.spi.Operation;
import com.atlassian.nutcluster.util.IterationType;
import java.security.Permission;
import java.util.ArrayList;

public class MapFetchWithQueryMessageTask
extends AbstractMapPartitionMessageTask<MapFetchWithQueryCodec.RequestParameters> {
    public MapFetchWithQueryMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected Operation prepareOperation() {
        MapOperationProvider operationProvider = this.getMapOperationProvider(((MapFetchWithQueryCodec.RequestParameters)this.parameters).name);
        Projection projection = (Projection)this.nodeEngine.getSerializationService().toObject(((MapFetchWithQueryCodec.RequestParameters)this.parameters).projection);
        Predicate predicate = (Predicate)this.nodeEngine.getSerializationService().toObject(((MapFetchWithQueryCodec.RequestParameters)this.parameters).predicate);
        Query query = Query.of().mapName(((MapFetchWithQueryCodec.RequestParameters)this.parameters).name).iterationType(IterationType.VALUE).predicate(predicate).projection(projection).build();
        return operationProvider.createFetchWithQueryOperation(((MapFetchWithQueryCodec.RequestParameters)this.parameters).name, ((MapFetchWithQueryCodec.RequestParameters)this.parameters).tableIndex, ((MapFetchWithQueryCodec.RequestParameters)this.parameters).batch, query);
    }

    @Override
    protected MapFetchWithQueryCodec.RequestParameters decodeClientMessage(ClientMessage clientMessage) {
        return MapFetchWithQueryCodec.decodeRequest(clientMessage);
    }

    @Override
    protected ClientMessage encodeResponse(Object response) {
        ResultSegment resp = (ResultSegment)response;
        QueryResult queryResult = (QueryResult)resp.getResult();
        ArrayList<Data> serialized = new ArrayList<Data>(queryResult.size());
        for (QueryResultRow row : queryResult) {
            serialized.add(row.getValue());
        }
        return MapFetchWithQueryCodec.encodeResponse(serialized, resp.getNextTableIndexToReadFrom());
    }

    @Override
    public String getServiceName() {
        return "hz:impl:mapService";
    }

    @Override
    public Permission getRequiredPermission() {
        return new MapPermission(((MapFetchWithQueryCodec.RequestParameters)this.parameters).name, "read");
    }

    @Override
    public String getDistributedObjectName() {
        return ((MapFetchWithQueryCodec.RequestParameters)this.parameters).name;
    }

    @Override
    public String getMethodName() {
        return "iterator";
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{((MapFetchWithQueryCodec.RequestParameters)this.parameters).batch, this.getPartitionId(), ((MapFetchWithQueryCodec.RequestParameters)this.parameters).projection, ((MapFetchWithQueryCodec.RequestParameters)this.parameters).predicate};
    }
}

