/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.client.impl.protocol.task.map;

import com.atlassian.nutcluster.client.impl.protocol.ClientMessage;
import com.atlassian.nutcluster.client.impl.protocol.codec.MapIsEmptyCodec;
import com.atlassian.nutcluster.client.impl.protocol.task.AbstractAllPartitionsMessageTask;
import com.atlassian.nutcluster.instance.Node;
import com.atlassian.nutcluster.map.impl.LocalMapStatsUtil;
import com.atlassian.nutcluster.map.impl.MapService;
import com.atlassian.nutcluster.map.impl.MapServiceContext;
import com.atlassian.nutcluster.map.impl.operation.IsEmptyOperationFactory;
import com.atlassian.nutcluster.nio.Connection;
import com.atlassian.nutcluster.security.permission.MapPermission;
import com.atlassian.nutcluster.spi.OperationFactory;
import java.security.Permission;
import java.util.Map;

public class MapIsEmptyMessageTask
extends AbstractAllPartitionsMessageTask<MapIsEmptyCodec.RequestParameters> {
    public MapIsEmptyMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected OperationFactory createOperationFactory() {
        return new IsEmptyOperationFactory(((MapIsEmptyCodec.RequestParameters)this.parameters).name);
    }

    @Override
    protected Object reduce(Map<Integer, Object> map) {
        MapService mapService = (MapService)this.getService("hz:impl:mapService");
        MapServiceContext mapServiceContext = mapService.getMapServiceContext();
        boolean response = true;
        for (Object result : map.values()) {
            boolean isEmpty = (Boolean)mapServiceContext.toObject(result);
            if (isEmpty) continue;
            response = false;
        }
        LocalMapStatsUtil.incrementOtherOperationsCount(mapService, ((MapIsEmptyCodec.RequestParameters)this.parameters).name);
        return response;
    }

    @Override
    protected MapIsEmptyCodec.RequestParameters decodeClientMessage(ClientMessage clientMessage) {
        return MapIsEmptyCodec.decodeRequest(clientMessage);
    }

    @Override
    protected ClientMessage encodeResponse(Object response) {
        return MapIsEmptyCodec.encodeResponse((Boolean)response);
    }

    @Override
    public String getServiceName() {
        return "hz:impl:mapService";
    }

    @Override
    public Permission getRequiredPermission() {
        return new MapPermission(((MapIsEmptyCodec.RequestParameters)this.parameters).name, "read");
    }

    @Override
    public String getDistributedObjectName() {
        return ((MapIsEmptyCodec.RequestParameters)this.parameters).name;
    }

    @Override
    public String getMethodName() {
        return "isEmpty";
    }

    @Override
    public Object[] getParameters() {
        return null;
    }
}

