/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.client.impl.protocol.task.map;

import com.atlassian.nutcluster.client.impl.protocol.ClientMessage;
import com.atlassian.nutcluster.client.impl.protocol.codec.ContinuousQueryPublisherCreateWithValueCodec;
import com.atlassian.nutcluster.client.impl.protocol.task.AbstractCallableMessageTask;
import com.atlassian.nutcluster.client.impl.protocol.task.BlockingMessageTask;
import com.atlassian.nutcluster.instance.MemberImpl;
import com.atlassian.nutcluster.instance.Node;
import com.atlassian.nutcluster.internal.cluster.ClusterService;
import com.atlassian.nutcluster.map.impl.query.QueryResult;
import com.atlassian.nutcluster.map.impl.query.QueryResultRow;
import com.atlassian.nutcluster.map.impl.querycache.accumulator.AccumulatorInfo;
import com.atlassian.nutcluster.map.impl.querycache.subscriber.operation.PublisherCreateOperation;
import com.atlassian.nutcluster.nio.Address;
import com.atlassian.nutcluster.nio.Connection;
import com.atlassian.nutcluster.nio.serialization.Data;
import com.atlassian.nutcluster.query.Predicate;
import com.atlassian.nutcluster.security.permission.MapPermission;
import com.atlassian.nutcluster.spi.InternalCompletableFuture;
import com.atlassian.nutcluster.spi.InvocationBuilder;
import com.atlassian.nutcluster.spi.Operation;
import com.atlassian.nutcluster.spi.impl.operationservice.InternalOperationService;
import com.atlassian.nutcluster.util.ExceptionUtil;
import com.atlassian.nutcluster.util.collection.InflatableSet;
import java.security.Permission;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;

public class MapPublisherCreateWithValueMessageTask
extends AbstractCallableMessageTask<ContinuousQueryPublisherCreateWithValueCodec.RequestParameters>
implements BlockingMessageTask {
    public MapPublisherCreateWithValueMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected Object call() throws Exception {
        ClusterService clusterService = this.clientEngine.getClusterService();
        Collection<MemberImpl> members = clusterService.getMemberImpls();
        List<Future> snapshotFutures = this.createPublishersAndGetSnapshotOf(members);
        return MapPublisherCreateWithValueMessageTask.fetchMapSnapshotFrom(snapshotFutures);
    }

    private List<Future> createPublishersAndGetSnapshotOf(Collection<MemberImpl> members) {
        ArrayList<Future> futures = new ArrayList<Future>(members.size());
        InternalOperationService operationService = this.nodeEngine.getOperationService();
        for (MemberImpl member : members) {
            Predicate predicate = (Predicate)this.serializationService.toObject(((ContinuousQueryPublisherCreateWithValueCodec.RequestParameters)this.parameters).predicate);
            AccumulatorInfo accumulatorInfo = AccumulatorInfo.toAccumulatorInfo(((ContinuousQueryPublisherCreateWithValueCodec.RequestParameters)this.parameters).mapName, ((ContinuousQueryPublisherCreateWithValueCodec.RequestParameters)this.parameters).cacheName, predicate, ((ContinuousQueryPublisherCreateWithValueCodec.RequestParameters)this.parameters).batchSize, ((ContinuousQueryPublisherCreateWithValueCodec.RequestParameters)this.parameters).bufferSize, ((ContinuousQueryPublisherCreateWithValueCodec.RequestParameters)this.parameters).delaySeconds, true, ((ContinuousQueryPublisherCreateWithValueCodec.RequestParameters)this.parameters).populate, ((ContinuousQueryPublisherCreateWithValueCodec.RequestParameters)this.parameters).coalesce);
            PublisherCreateOperation operation = new PublisherCreateOperation(accumulatorInfo);
            operation.setCallerUuid(this.endpoint.getUuid());
            Address address = member.getAddress();
            InvocationBuilder invocationBuilder = operationService.createInvocationBuilder("hz:impl:mapService", (Operation)operation, address);
            InternalCompletableFuture future = invocationBuilder.invoke();
            futures.add(future);
        }
        return futures;
    }

    private static Set<Map.Entry<Data, Data>> fetchMapSnapshotFrom(List<Future> futures) {
        ArrayList<Object> queryResults = new ArrayList<Object>(futures.size());
        int queryResultSize = 0;
        for (Future future : futures) {
            Object result;
            try {
                result = future.get();
            }
            catch (Exception e) {
                throw ExceptionUtil.rethrow(e);
            }
            if (result == null) continue;
            queryResults.add(result);
            queryResultSize += ((QueryResult)result).size();
        }
        return MapPublisherCreateWithValueMessageTask.unpackResults(queryResults, queryResultSize);
    }

    private static Set<Map.Entry<Data, Data>> unpackResults(List<Object> results, int numOfEntries) {
        InflatableSet.Builder<AbstractMap.SimpleEntry<Data, Data>> builder = InflatableSet.newBuilder(numOfEntries);
        for (Object result : results) {
            for (QueryResultRow row : (QueryResult)result) {
                builder.add(new AbstractMap.SimpleEntry<Data, Data>(row.getKey(), row.getValue()));
            }
        }
        return builder.build();
    }

    @Override
    protected ContinuousQueryPublisherCreateWithValueCodec.RequestParameters decodeClientMessage(ClientMessage clientMessage) {
        return ContinuousQueryPublisherCreateWithValueCodec.decodeRequest(clientMessage);
    }

    @Override
    protected ClientMessage encodeResponse(Object response) {
        return ContinuousQueryPublisherCreateWithValueCodec.encodeResponse((Set)response);
    }

    @Override
    public String getServiceName() {
        return "hz:impl:mapService";
    }

    @Override
    public Permission getRequiredPermission() {
        return new MapPermission(((ContinuousQueryPublisherCreateWithValueCodec.RequestParameters)this.parameters).mapName, "listen");
    }

    @Override
    public String getDistributedObjectName() {
        return null;
    }

    @Override
    public String getMethodName() {
        return null;
    }

    @Override
    public Object[] getParameters() {
        return null;
    }
}

