/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.client.impl.protocol.task.multimap;

import com.atlassian.nutcluster.client.impl.protocol.ClientMessage;
import com.atlassian.nutcluster.client.impl.protocol.task.AbstractCallableMessageTask;
import com.atlassian.nutcluster.client.impl.protocol.task.ListenerMessageTask;
import com.atlassian.nutcluster.core.EntryAdapter;
import com.atlassian.nutcluster.core.EntryEvent;
import com.atlassian.nutcluster.core.EntryEventType;
import com.atlassian.nutcluster.core.MapEvent;
import com.atlassian.nutcluster.instance.Node;
import com.atlassian.nutcluster.map.impl.DataAwareEntryEvent;
import com.atlassian.nutcluster.multimap.impl.MultiMapService;
import com.atlassian.nutcluster.nio.Connection;
import com.atlassian.nutcluster.nio.serialization.Data;
import com.atlassian.nutcluster.security.permission.MultiMapPermission;
import java.security.Permission;

public abstract class AbstractMultiMapAddEntryListenerMessageTask<P>
extends AbstractCallableMessageTask<P>
implements ListenerMessageTask {
    public AbstractMultiMapAddEntryListenerMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected Object call() throws Exception {
        MultiMapService service = (MultiMapService)this.getService("hz:impl:multiMapService");
        MultiMapListener listener = new MultiMapListener();
        String name = this.getDistributedObjectName();
        Data key = this.getKey();
        boolean includeValue = this.shouldIncludeValue();
        String registrationId = service.addListener(name, listener, key, includeValue, this.isLocalOnly());
        this.endpoint.addListenerDestroyAction("hz:impl:multiMapService", name, registrationId);
        return registrationId;
    }

    protected abstract boolean shouldIncludeValue();

    protected abstract boolean isLocalOnly();

    @Override
    public String getServiceName() {
        return "hz:impl:multiMapService";
    }

    @Override
    public Permission getRequiredPermission() {
        return new MultiMapPermission(this.getDistributedObjectName(), "listen");
    }

    @Override
    public String getMethodName() {
        return "addEntryListener";
    }

    public Data getKey() {
        return null;
    }

    protected abstract ClientMessage encodeEvent(Data var1, Data var2, Data var3, int var4, String var5, int var6);

    private class MultiMapListener
    extends EntryAdapter<Object, Object> {
        private MultiMapListener() {
        }

        @Override
        public void onEntryEvent(EntryEvent event) {
            if (AbstractMultiMapAddEntryListenerMessageTask.this.endpoint.isAlive()) {
                if (!(event instanceof DataAwareEntryEvent)) {
                    throw new IllegalArgumentException("Expecting: DataAwareEntryEvent, Found: " + event.getClass().getSimpleName());
                }
                DataAwareEntryEvent dataAwareEntryEvent = (DataAwareEntryEvent)event;
                Data key = dataAwareEntryEvent.getKeyData();
                Data value = dataAwareEntryEvent.getNewValueData();
                Data oldValue = dataAwareEntryEvent.getOldValueData();
                EntryEventType type = event.getEventType();
                String uuid = event.getMember().getUuid();
                AbstractMultiMapAddEntryListenerMessageTask.this.sendClientMessage(key, AbstractMultiMapAddEntryListenerMessageTask.this.encodeEvent(key, value, oldValue, type.getType(), uuid, 1));
            }
        }

        @Override
        public void onMapEvent(MapEvent event) {
            if (AbstractMultiMapAddEntryListenerMessageTask.this.endpoint.isAlive()) {
                EntryEventType type = event.getEventType();
                String uuid = event.getMember().getUuid();
                AbstractMultiMapAddEntryListenerMessageTask.this.sendClientMessage(null, AbstractMultiMapAddEntryListenerMessageTask.this.encodeEvent(null, null, null, type.getType(), uuid, event.getNumberOfEntriesAffected()));
            }
        }
    }
}

