/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.cluster.memberselector;

import com.atlassian.nutcluster.cluster.memberselector.AndMemberSelector;
import com.atlassian.nutcluster.cluster.memberselector.OrMemberSelector;
import com.atlassian.nutcluster.core.Member;
import com.atlassian.nutcluster.core.MemberSelector;

public final class MemberSelectors {
    public static final MemberSelector LITE_MEMBER_SELECTOR = new MemberSelector(){

        @Override
        public boolean select(Member member) {
            return member.isLiteMember();
        }
    };
    public static final MemberSelector DATA_MEMBER_SELECTOR = new MemberSelector(){

        @Override
        public boolean select(Member member) {
            return !member.isLiteMember();
        }
    };
    public static final MemberSelector LOCAL_MEMBER_SELECTOR = new MemberSelector(){

        @Override
        public boolean select(Member member) {
            return member.localMember();
        }
    };
    public static final MemberSelector NON_LOCAL_MEMBER_SELECTOR = new MemberSelector(){

        @Override
        public boolean select(Member member) {
            return !member.localMember();
        }
    };

    private MemberSelectors() {
    }

    public static MemberSelector or(MemberSelector ... selectors) {
        return new OrMemberSelector(selectors);
    }

    public static MemberSelector and(MemberSelector ... selectors) {
        return new AndMemberSelector(selectors);
    }
}

