/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.collection.impl.queue;

import com.atlassian.nutcluster.collection.impl.queue.QueueDataSerializerHook;
import com.atlassian.nutcluster.core.ItemEventType;
import com.atlassian.nutcluster.nio.Address;
import com.atlassian.nutcluster.nio.ObjectDataInput;
import com.atlassian.nutcluster.nio.ObjectDataOutput;
import com.atlassian.nutcluster.nio.serialization.Data;
import com.atlassian.nutcluster.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;

public class QueueEvent
implements IdentifiedDataSerializable {
    String name;
    Data data;
    ItemEventType eventType;
    Address caller;

    public QueueEvent() {
    }

    public QueueEvent(String name, Data data, ItemEventType eventType, Address caller) {
        this.name = name;
        this.data = data;
        this.eventType = eventType;
        this.caller = caller;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeUTF(this.name);
        out.writeInt(this.eventType.getType());
        this.caller.writeData(out);
        out.writeData(this.data);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.name = in.readUTF();
        this.eventType = ItemEventType.getByType(in.readInt());
        this.caller = new Address();
        this.caller.readData(in);
        this.data = in.readData();
    }

    @Override
    public int getFactoryId() {
        return QueueDataSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return 15;
    }

    public String getName() {
        return this.name;
    }

    public ItemEventType getEventType() {
        return this.eventType;
    }
}

