/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.collection.impl.txncollection.operations;

import com.atlassian.nutcluster.collection.impl.CollectionTxnUtil;
import com.atlassian.nutcluster.collection.impl.collection.CollectionContainer;
import com.atlassian.nutcluster.collection.impl.collection.operations.CollectionOperation;
import com.atlassian.nutcluster.nio.ObjectDataInput;
import com.atlassian.nutcluster.nio.ObjectDataOutput;
import com.atlassian.nutcluster.spi.BackupOperation;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;

public class CollectionRollbackBackupOperation
extends CollectionOperation
implements BackupOperation {
    private long[] itemIds;

    public CollectionRollbackBackupOperation() {
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public CollectionRollbackBackupOperation(String name, long[] itemIds) {
        super(name);
        this.itemIds = itemIds;
    }

    @Override
    public void run() throws Exception {
        CollectionContainer collectionContainer = this.getOrCreateContainer();
        for (long itemId : this.itemIds) {
            if (CollectionTxnUtil.isRemove(itemId)) {
                collectionContainer.rollbackRemoveBackup(itemId);
                continue;
            }
            collectionContainer.rollbackAddBackup(-itemId);
        }
    }

    @Override
    public int getId() {
        return 33;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeLongArray(this.itemIds);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.itemIds = in.readLongArray();
    }
}

