/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.collection.impl.txnqueue.operations;

import com.atlassian.nutcluster.collection.impl.CollectionTxnUtil;
import com.atlassian.nutcluster.collection.impl.queue.QueueContainer;
import com.atlassian.nutcluster.collection.impl.queue.operations.QueueBackupAwareOperation;
import com.atlassian.nutcluster.collection.impl.txnqueue.operations.TxnRollbackBackupOperation;
import com.atlassian.nutcluster.nio.ObjectDataInput;
import com.atlassian.nutcluster.nio.ObjectDataOutput;
import com.atlassian.nutcluster.spi.Notifier;
import com.atlassian.nutcluster.spi.Operation;
import com.atlassian.nutcluster.spi.WaitNotifyKey;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;

public class TxnRollbackOperation
extends QueueBackupAwareOperation
implements Notifier {
    private long[] itemIds;
    private transient long shouldNotify;

    public TxnRollbackOperation() {
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public TxnRollbackOperation(int partitionId, String name, long[] itemIds) {
        super(name);
        this.setPartitionId(partitionId);
        this.itemIds = itemIds;
    }

    @Override
    public void run() throws Exception {
        QueueContainer queueContainer = this.getContainer();
        for (long itemId : this.itemIds) {
            this.response = CollectionTxnUtil.isRemove(itemId) ? Boolean.valueOf(queueContainer.txnRollbackPoll(itemId, false)) : Boolean.valueOf(queueContainer.txnRollbackOffer(-itemId));
        }
    }

    @Override
    public boolean shouldBackup() {
        return true;
    }

    @Override
    public Operation getBackupOperation() {
        return new TxnRollbackBackupOperation(this.name, this.itemIds);
    }

    @Override
    public boolean shouldNotify() {
        for (long itemId : this.itemIds) {
            this.shouldNotify += CollectionTxnUtil.isRemove(itemId) ? 1L : -1L;
        }
        return this.shouldNotify != 0L;
    }

    @Override
    public WaitNotifyKey getNotifiedKey() {
        QueueContainer queueContainer = this.getContainer();
        if (CollectionTxnUtil.isRemove(this.shouldNotify)) {
            return queueContainer.getPollWaitNotifyKey();
        }
        return queueContainer.getOfferWaitNotifyKey();
    }

    @Override
    public int getId() {
        return 34;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeLongArray(this.itemIds);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.itemIds = in.readLongArray();
    }
}

