/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.concurrent.atomiclong.operations;

import com.atlassian.nutcluster.concurrent.atomiclong.AtomicLongContainer;
import com.atlassian.nutcluster.concurrent.atomiclong.operations.AddBackupOperation;
import com.atlassian.nutcluster.concurrent.atomiclong.operations.AtomicLongBackupAwareOperation;
import com.atlassian.nutcluster.nio.ObjectDataInput;
import com.atlassian.nutcluster.nio.ObjectDataOutput;
import com.atlassian.nutcluster.spi.Operation;
import com.atlassian.nutcluster.spi.impl.MutatingOperation;
import java.io.IOException;

public class GetAndAddOperation
extends AtomicLongBackupAwareOperation
implements MutatingOperation {
    private long delta;
    private long returnValue;

    public GetAndAddOperation() {
    }

    public GetAndAddOperation(String name, long delta) {
        super(name);
        this.delta = delta;
    }

    @Override
    public void run() throws Exception {
        AtomicLongContainer container = this.getLongContainer();
        this.returnValue = container.getAndAdd(this.delta);
    }

    @Override
    public Object getResponse() {
        return this.returnValue;
    }

    @Override
    public Operation getBackupOperation() {
        return new AddBackupOperation(this.name, this.delta);
    }

    @Override
    public int getId() {
        return 9;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeLong(this.delta);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.delta = in.readLong();
    }
}

