/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.concurrent.atomiclong.operations;

import com.atlassian.nutcluster.concurrent.atomiclong.AtomicLongContainer;
import com.atlassian.nutcluster.concurrent.atomiclong.operations.AtomicLongBackupAwareOperation;
import com.atlassian.nutcluster.concurrent.atomiclong.operations.SetBackupOperation;
import com.atlassian.nutcluster.nio.ObjectDataInput;
import com.atlassian.nutcluster.nio.ObjectDataOutput;
import com.atlassian.nutcluster.spi.Operation;
import com.atlassian.nutcluster.spi.impl.MutatingOperation;
import java.io.IOException;

public class GetAndSetOperation
extends AtomicLongBackupAwareOperation
implements MutatingOperation {
    private long newValue;
    private long returnValue;

    public GetAndSetOperation() {
    }

    public GetAndSetOperation(String name, long newValue) {
        super(name);
        this.newValue = newValue;
    }

    @Override
    public void run() throws Exception {
        AtomicLongContainer container = this.getLongContainer();
        this.returnValue = container.getAndSet(this.newValue);
    }

    @Override
    public Object getResponse() {
        return this.returnValue;
    }

    @Override
    public Operation getBackupOperation() {
        return new SetBackupOperation(this.name, this.newValue);
    }

    @Override
    public int getId() {
        return 7;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeLong(this.newValue);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.newValue = in.readLong();
    }
}

