/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.config;

import com.atlassian.nutcluster.config.AliasedDiscoveryConfig;
import com.atlassian.nutcluster.config.AwsConfig;
import com.atlassian.nutcluster.config.AzureConfig;
import com.atlassian.nutcluster.config.DiscoveryStrategyConfig;
import com.atlassian.nutcluster.config.EurekaConfig;
import com.atlassian.nutcluster.config.GcpConfig;
import com.atlassian.nutcluster.config.InvalidConfigurationException;
import com.atlassian.nutcluster.config.JoinConfig;
import com.atlassian.nutcluster.config.KubernetesConfig;
import com.atlassian.nutcluster.config.WanPublisherConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class AliasedDiscoveryConfigUtils {
    private static final Map<String, String> ALIAS_MAPPINGS = new HashMap<String, String>();

    private AliasedDiscoveryConfigUtils() {
    }

    public static boolean supports(String tag) {
        return ALIAS_MAPPINGS.containsKey(tag);
    }

    public static String tagFor(AliasedDiscoveryConfig config) {
        return config.getTag();
    }

    public static List<DiscoveryStrategyConfig> createDiscoveryStrategyConfigs(JoinConfig config) {
        return AliasedDiscoveryConfigUtils.map(AliasedDiscoveryConfigUtils.aliasedDiscoveryConfigsFrom(config));
    }

    public static List<DiscoveryStrategyConfig> createDiscoveryStrategyConfigs(WanPublisherConfig config) {
        return AliasedDiscoveryConfigUtils.map(AliasedDiscoveryConfigUtils.aliasedDiscoveryConfigsFrom(config));
    }

    public static List<DiscoveryStrategyConfig> map(List<AliasedDiscoveryConfig<?>> aliasedDiscoveryConfigs) {
        ArrayList<DiscoveryStrategyConfig> result = new ArrayList<DiscoveryStrategyConfig>();
        for (AliasedDiscoveryConfig<?> config : aliasedDiscoveryConfigs) {
            if (!config.isEnabled()) continue;
            result.add(AliasedDiscoveryConfigUtils.createDiscoveryStrategyConfig(config));
        }
        return result;
    }

    private static DiscoveryStrategyConfig createDiscoveryStrategyConfig(AliasedDiscoveryConfig<?> config) {
        AliasedDiscoveryConfigUtils.validateConfig(config);
        String className = AliasedDiscoveryConfigUtils.discoveryStrategyFrom(config);
        HashMap<String, Comparable> properties = new HashMap<String, Comparable>();
        for (String key : config.getProperties().keySet()) {
            AliasedDiscoveryConfigUtils.putIfKeyNotNull(properties, key, config.getProperties().get(key));
        }
        return new DiscoveryStrategyConfig(className, properties);
    }

    private static void validateConfig(AliasedDiscoveryConfig config) {
        if (!ALIAS_MAPPINGS.containsKey(config.getTag())) {
            throw new InvalidConfigurationException(String.format("Invalid configuration class: '%s'", config.getClass().getName()));
        }
    }

    private static String discoveryStrategyFrom(AliasedDiscoveryConfig config) {
        return ALIAS_MAPPINGS.get(config.getTag());
    }

    private static void putIfKeyNotNull(Map<String, Comparable> properties, String key, String value) {
        if (key != null) {
            properties.put(key, (Comparable)((Object)value));
        }
    }

    public static AliasedDiscoveryConfig getConfigByTag(JoinConfig config, String tag) {
        if ("aws".equals(tag)) {
            return config.getAwsConfig();
        }
        if ("gcp".equals(tag)) {
            return config.getGcpConfig();
        }
        if ("azure".equals(tag)) {
            return config.getAzureConfig();
        }
        if ("kubernetes".equals(tag)) {
            return config.getKubernetesConfig();
        }
        if ("eureka".equals(tag)) {
            return config.getEurekaConfig();
        }
        throw new IllegalArgumentException(String.format("Invalid tag: '%s'", tag));
    }

    public static AliasedDiscoveryConfig getConfigByTag(WanPublisherConfig config, String tag) {
        if ("aws".equals(tag)) {
            return config.getAwsConfig();
        }
        if ("gcp".equals(tag)) {
            return config.getGcpConfig();
        }
        if ("azure".equals(tag)) {
            return config.getAzureConfig();
        }
        if ("kubernetes".equals(tag)) {
            return config.getKubernetesConfig();
        }
        if ("eureka".equals(tag)) {
            return config.getEurekaConfig();
        }
        throw new IllegalArgumentException(String.format("Invalid tag: '%s'", tag));
    }

    public static List<AliasedDiscoveryConfig<?>> aliasedDiscoveryConfigsFrom(JoinConfig config) {
        return Arrays.asList(config.getAwsConfig(), config.getGcpConfig(), config.getAzureConfig(), config.getKubernetesConfig(), config.getEurekaConfig());
    }

    public static List<AliasedDiscoveryConfig<?>> aliasedDiscoveryConfigsFrom(WanPublisherConfig config) {
        return Arrays.asList(config.getAwsConfig(), config.getGcpConfig(), config.getAzureConfig(), config.getKubernetesConfig(), config.getEurekaConfig());
    }

    public static boolean allUsePublicAddress(List<AliasedDiscoveryConfig<?>> configs) {
        boolean atLeastOneEnabled = false;
        for (AliasedDiscoveryConfig<?> config : configs) {
            if (!config.isEnabled()) continue;
            atLeastOneEnabled = true;
            if (config.isUsePublicIp()) continue;
            return false;
        }
        return atLeastOneEnabled;
    }

    public static AliasedDiscoveryConfig newConfigFor(String tag) {
        if ("aws".equals(tag)) {
            return new AwsConfig();
        }
        if ("gcp".equals(tag)) {
            return new GcpConfig();
        }
        if ("azure".equals(tag)) {
            return new AzureConfig();
        }
        if ("kubernetes".equals(tag)) {
            return new KubernetesConfig();
        }
        if ("eureka".equals(tag)) {
            return new EurekaConfig();
        }
        throw new IllegalArgumentException(String.format("Invalid tag: '%s'", tag));
    }

    static {
        ALIAS_MAPPINGS.put("aws", "com.atlassian.nutcluster.aws.AwsDiscoveryStrategy");
        ALIAS_MAPPINGS.put("gcp", "com.hazelcast.gcp.GcpDiscoveryStrategy");
        ALIAS_MAPPINGS.put("azure", "com.atlassian.nutcluster.azure.AzureDiscoveryStrategy");
        ALIAS_MAPPINGS.put("kubernetes", "com.atlassian.nutcluster.kubernetes.NutclusterKubernetesDiscoveryStrategy");
        ALIAS_MAPPINGS.put("eureka", "com.atlassian.nutcluster.eureka.one.EurekaOneDiscoveryStrategy");
    }
}

