/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.config;

import com.atlassian.nutcluster.config.Config;
import com.atlassian.nutcluster.config.XmlConfigBuilder;
import com.atlassian.nutcluster.logging.ILogger;
import com.atlassian.nutcluster.logging.Logger;
import com.atlassian.nutcluster.util.Preconditions;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.Properties;

public class FileSystemXmlConfig
extends Config {
    private static final ILogger LOGGER = Logger.getLogger(FileSystemXmlConfig.class);

    public FileSystemXmlConfig(String configFilename) throws FileNotFoundException {
        this(configFilename, System.getProperties());
    }

    public FileSystemXmlConfig(String configFilename, Properties properties) throws FileNotFoundException {
        this(new File(configFilename), properties);
    }

    public FileSystemXmlConfig(File configFile) throws FileNotFoundException {
        this(configFile, System.getProperties());
    }

    public FileSystemXmlConfig(File configFile, Properties properties) throws FileNotFoundException {
        Preconditions.checkTrue(configFile != null, "configFile can't be null");
        Preconditions.checkTrue(properties != null, "properties can't be null");
        LOGGER.info("Configuring Nutcluster from '" + configFile.getAbsolutePath() + "'.");
        FileInputStream in = new FileInputStream(configFile);
        new XmlConfigBuilder(in).setProperties(properties).build(this);
    }
}

