/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.config;

import com.atlassian.nutcluster.config.Config;
import com.atlassian.nutcluster.config.XmlConfigBuilder;
import com.atlassian.nutcluster.logging.ILogger;
import com.atlassian.nutcluster.logging.Logger;
import com.atlassian.nutcluster.util.Preconditions;
import com.atlassian.nutcluster.util.StringUtil;
import java.io.ByteArrayInputStream;
import java.util.Properties;

public class InMemoryXmlConfig
extends Config {
    private static final ILogger LOGGER = Logger.getLogger(InMemoryXmlConfig.class);

    public InMemoryXmlConfig(String xml) {
        this(xml, System.getProperties());
    }

    public InMemoryXmlConfig(String xml, Properties properties) {
        LOGGER.info("Configuring Nutcluster from 'in-memory xml'.");
        if (StringUtil.isNullOrEmptyAfterTrim(xml)) {
            throw new IllegalArgumentException("XML configuration is null or empty! Please use a well-structured xml.");
        }
        Preconditions.checkTrue(properties != null, "properties can't be null");
        ByteArrayInputStream in = new ByteArrayInputStream(StringUtil.stringToBytes(xml));
        new XmlConfigBuilder(in).setProperties(properties).build(this);
    }
}

