/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.config;

import com.atlassian.nutcluster.config.AwsConfig;
import com.atlassian.nutcluster.config.AzureConfig;
import com.atlassian.nutcluster.config.DiscoveryConfig;
import com.atlassian.nutcluster.config.DiscoveryStrategyConfig;
import com.atlassian.nutcluster.config.EurekaConfig;
import com.atlassian.nutcluster.config.GcpConfig;
import com.atlassian.nutcluster.config.InvalidConfigurationException;
import com.atlassian.nutcluster.config.KubernetesConfig;
import com.atlassian.nutcluster.config.MulticastConfig;
import com.atlassian.nutcluster.config.TcpIpConfig;
import com.atlassian.nutcluster.util.Preconditions;
import java.util.Collection;

public class JoinConfig {
    private MulticastConfig multicastConfig = new MulticastConfig();
    private TcpIpConfig tcpIpConfig = new TcpIpConfig();
    private AwsConfig awsConfig = new AwsConfig();
    private GcpConfig gcpConfig = new GcpConfig();
    private AzureConfig azureConfig = new AzureConfig();
    private KubernetesConfig kubernetesConfig = new KubernetesConfig();
    private EurekaConfig eurekaConfig = new EurekaConfig();
    private DiscoveryConfig discoveryConfig = new DiscoveryConfig();

    public MulticastConfig getMulticastConfig() {
        return this.multicastConfig;
    }

    public JoinConfig setMulticastConfig(MulticastConfig multicastConfig) {
        this.multicastConfig = Preconditions.isNotNull(multicastConfig, "multicastConfig");
        return this;
    }

    public TcpIpConfig getTcpIpConfig() {
        return this.tcpIpConfig;
    }

    public JoinConfig setTcpIpConfig(TcpIpConfig tcpIpConfig) {
        this.tcpIpConfig = Preconditions.isNotNull(tcpIpConfig, "tcpIpConfig");
        return this;
    }

    public AwsConfig getAwsConfig() {
        return this.awsConfig;
    }

    public JoinConfig setAwsConfig(AwsConfig awsConfig) {
        this.awsConfig = Preconditions.isNotNull(awsConfig, "awsConfig");
        return this;
    }

    public GcpConfig getGcpConfig() {
        return this.gcpConfig;
    }

    public JoinConfig setGcpConfig(GcpConfig gcpConfig) {
        this.gcpConfig = Preconditions.isNotNull(gcpConfig, "gcpConfig");
        return this;
    }

    public AzureConfig getAzureConfig() {
        return this.azureConfig;
    }

    public JoinConfig setAzureConfig(AzureConfig azureConfig) {
        this.azureConfig = Preconditions.isNotNull(azureConfig, "azureConfig");
        return this;
    }

    public KubernetesConfig getKubernetesConfig() {
        return this.kubernetesConfig;
    }

    public JoinConfig setKubernetesConfig(KubernetesConfig kubernetesConfig) {
        this.kubernetesConfig = Preconditions.isNotNull(kubernetesConfig, "kubernetesConfig");
        return this;
    }

    public EurekaConfig getEurekaConfig() {
        return this.eurekaConfig;
    }

    public JoinConfig setEurekaConfig(EurekaConfig eurekaConfig) {
        this.eurekaConfig = Preconditions.isNotNull(eurekaConfig, "eurekaConfig");
        return this;
    }

    public DiscoveryConfig getDiscoveryConfig() {
        return this.discoveryConfig;
    }

    public JoinConfig setDiscoveryConfig(DiscoveryConfig discoveryConfig) {
        this.discoveryConfig = Preconditions.isNotNull(discoveryConfig, "discoveryProvidersConfig");
        return this;
    }

    public void verify() {
        Collection<DiscoveryStrategyConfig> discoveryStrategyConfigs;
        int countEnabled = 0;
        if (this.getTcpIpConfig().isEnabled()) {
            ++countEnabled;
        }
        if (this.getMulticastConfig().isEnabled()) {
            ++countEnabled;
        }
        if (this.getAwsConfig().isEnabled()) {
            ++countEnabled;
        }
        if (this.getGcpConfig().isEnabled()) {
            ++countEnabled;
        }
        if (this.getAzureConfig().isEnabled()) {
            ++countEnabled;
        }
        if (this.getKubernetesConfig().isEnabled()) {
            ++countEnabled;
        }
        if (this.getEurekaConfig().isEnabled()) {
            ++countEnabled;
        }
        if ((countEnabled += (discoveryStrategyConfigs = this.discoveryConfig.getDiscoveryStrategyConfigs()).size()) > 1) {
            throw new InvalidConfigurationException("Multiple join configuration cannot be enabled at the same time. Enable only one of: TCP/IP, Multicast, AWS, GCP, Azure, Kubernetes, Eureka or Discovery Strategy");
        }
    }

    public String toString() {
        return "JoinConfig{multicastConfig=" + String.valueOf(this.multicastConfig) + ", tcpIpConfig=" + String.valueOf(this.tcpIpConfig) + ", awsConfig=" + String.valueOf(this.awsConfig) + ", gcpConfig=" + String.valueOf(this.gcpConfig) + ", azureConfig=" + String.valueOf(this.azureConfig) + ", kubernetesConfig=" + String.valueOf(this.kubernetesConfig) + ", eurekaConfig=" + String.valueOf(this.eurekaConfig) + ", discoveryConfig=" + String.valueOf(this.discoveryConfig) + "}";
    }
}

