/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.config;

import com.atlassian.nutcluster.config.AbstractYamlConfigBuilder;
import com.atlassian.nutcluster.config.Config;
import com.atlassian.nutcluster.config.ConfigBuilder;
import com.atlassian.nutcluster.config.ConfigSections;
import com.atlassian.nutcluster.config.InvalidConfigurationException;
import com.atlassian.nutcluster.config.YamlConfigLocator;
import com.atlassian.nutcluster.config.YamlMemberDomConfigProcessor;
import com.atlassian.nutcluster.config.yaml.W3cDomUtil;
import com.atlassian.nutcluster.config.yaml.YamlDomChecker;
import com.atlassian.nutcluster.internal.yaml.YamlLoader;
import com.atlassian.nutcluster.internal.yaml.YamlMapping;
import com.atlassian.nutcluster.internal.yaml.YamlUtil;
import com.atlassian.nutcluster.nio.IOUtil;
import com.atlassian.nutcluster.util.ExceptionUtil;
import com.atlassian.nutcluster.util.Preconditions;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.w3c.dom.Node;

public class YamlConfigBuilder
extends AbstractYamlConfigBuilder
implements ConfigBuilder {
    private final InputStream in;
    private File configurationFile;
    private URL configurationUrl;

    public YamlConfigBuilder(String yamlFileName) throws FileNotFoundException {
        this(new FileInputStream(yamlFileName));
        this.configurationFile = new File(yamlFileName);
    }

    public YamlConfigBuilder(InputStream inputStream) {
        Preconditions.checkTrue(inputStream != null, "inputStream can't be null");
        this.in = inputStream;
    }

    public YamlConfigBuilder(URL url) throws IOException {
        Preconditions.checkNotNull(url, "URL is null!");
        this.in = url.openStream();
        this.configurationUrl = url;
    }

    public YamlConfigBuilder() {
        this((YamlConfigLocator)null);
    }

    public YamlConfigBuilder(YamlConfigLocator locator) {
        if (locator == null) {
            locator = new YamlConfigLocator(true);
            locator.locateEverywhere();
        }
        this.in = locator.getIn();
        this.configurationFile = locator.getConfigurationFile();
        this.configurationUrl = locator.getConfigurationUrl();
    }

    @Override
    public Config build() {
        return this.build(new Config());
    }

    Config build(Config config) {
        YamlUtil.ensureRunningOnJava8OrHigher();
        config.setConfigurationFile(this.configurationFile);
        config.setConfigurationUrl(this.configurationUrl);
        try {
            this.parseAndBuildConfig(config);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
        finally {
            IOUtil.closeResource(this.in);
        }
        return config;
    }

    private void parseAndBuildConfig(Config config) throws Exception {
        YamlMapping yamlRootNode;
        try {
            yamlRootNode = (YamlMapping)YamlLoader.load(this.in);
        }
        catch (Exception ex) {
            throw new InvalidConfigurationException("Invalid YAML configuration", ex);
        }
        YamlMapping imdgRoot = yamlRootNode.childAsMapping(ConfigSections.NUTCLUSTER.name);
        if (imdgRoot == null) {
            throw new InvalidConfigurationException("No mapping with nutcluster key is found in the provided configuration");
        }
        YamlDomChecker.check(imdgRoot);
        Node w3cRootNode = W3cDomUtil.asW3cNode(imdgRoot);
        this.replaceVariables(w3cRootNode);
        this.importDocuments(imdgRoot);
        new YamlMemberDomConfigProcessor(true, config).buildConfig(w3cRootNode);
    }

    public YamlConfigBuilder setProperties(Properties properties) {
        this.setPropertiesInternal(properties);
        return this;
    }

    @Override
    protected String getConfigRoot() {
        return ConfigSections.NUTCLUSTER.name;
    }
}

