/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.core;

import com.atlassian.nutcluster.cluster.MemberAttributeOperationType;
import com.atlassian.nutcluster.core.Cluster;
import com.atlassian.nutcluster.core.Member;
import com.atlassian.nutcluster.core.MembershipEvent;
import com.atlassian.nutcluster.instance.MemberImpl;
import com.atlassian.nutcluster.nio.IOUtil;
import com.atlassian.nutcluster.nio.ObjectDataInput;
import com.atlassian.nutcluster.nio.ObjectDataOutput;
import com.atlassian.nutcluster.nio.serialization.DataSerializable;
import com.atlassian.nutcluster.nio.serialization.SerializableByConvention;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.Collections;

@SerializableByConvention(value=SerializableByConvention.Reason.PUBLIC_API)
@SuppressFBWarnings(value={"SE_BAD_FIELD"})
public class MemberAttributeEvent
extends MembershipEvent
implements DataSerializable {
    private MemberAttributeOperationType operationType;
    private String key;
    private Object value;
    private Member member;

    public MemberAttributeEvent() {
        super(null, null, 5, Collections.EMPTY_SET);
    }

    public MemberAttributeEvent(Cluster cluster, Member member, MemberAttributeOperationType operationType, String key, Object value) {
        super(cluster, member, 5, Collections.EMPTY_SET);
        this.member = member;
        this.operationType = operationType;
        this.key = key;
        this.value = value;
    }

    public MemberAttributeOperationType getOperationType() {
        return this.operationType;
    }

    public String getKey() {
        return this.key;
    }

    public Object getValue() {
        return this.value;
    }

    @Override
    public Member getMember() {
        return this.member;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeUTF(this.key);
        this.member.writeData(out);
        out.writeByte(this.operationType.getId());
        if (this.operationType == MemberAttributeOperationType.PUT) {
            IOUtil.writeAttributeValue(this.value, out);
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.key = in.readUTF();
        this.member = new MemberImpl();
        this.member.readData(in);
        this.operationType = MemberAttributeOperationType.getValue(in.readByte());
        if (this.operationType == MemberAttributeOperationType.PUT) {
            this.value = IOUtil.readAttributeValue(in);
        }
        this.source = this.member;
    }
}

