/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.cp.internal.datastructures.lock.proxy;

import com.atlassian.nutcluster.cp.internal.RaftGroupId;
import com.atlassian.nutcluster.cp.internal.RaftInvocationManager;
import com.atlassian.nutcluster.cp.internal.RaftOp;
import com.atlassian.nutcluster.cp.internal.RaftService;
import com.atlassian.nutcluster.cp.internal.datastructures.lock.RaftLockOwnershipState;
import com.atlassian.nutcluster.cp.internal.datastructures.lock.operation.GetLockOwnershipStateOp;
import com.atlassian.nutcluster.cp.internal.datastructures.lock.operation.LockOp;
import com.atlassian.nutcluster.cp.internal.datastructures.lock.operation.TryLockOp;
import com.atlassian.nutcluster.cp.internal.datastructures.lock.operation.UnlockOp;
import com.atlassian.nutcluster.cp.internal.datastructures.lock.proxy.AbstractRaftFencedLockProxy;
import com.atlassian.nutcluster.cp.internal.datastructures.spi.operation.DestroyRaftObjectOp;
import com.atlassian.nutcluster.cp.internal.session.ProxySessionManagerService;
import com.atlassian.nutcluster.spi.InternalCompletableFuture;
import com.atlassian.nutcluster.spi.NodeEngine;
import java.util.UUID;

public class RaftFencedLockProxy
extends AbstractRaftFencedLockProxy {
    private final RaftInvocationManager invocationManager;

    public RaftFencedLockProxy(NodeEngine nodeEngine, RaftGroupId groupId, String proxyName, String objectName) {
        super((ProxySessionManagerService)nodeEngine.getService("hz:raft:proxySessionManagerService"), groupId, proxyName, objectName);
        RaftService service = (RaftService)nodeEngine.getService("hz:core:raft");
        this.invocationManager = service.getInvocationManager();
    }

    @Override
    protected final InternalCompletableFuture<Long> doLock(long sessionId, long threadId, UUID invocationUid) {
        return this.invoke(new LockOp(this.objectName, sessionId, threadId, invocationUid));
    }

    @Override
    protected final InternalCompletableFuture<Long> doTryLock(long sessionId, long threadId, UUID invocationUid, long timeoutMillis) {
        return this.invoke(new TryLockOp(this.objectName, sessionId, threadId, invocationUid, timeoutMillis));
    }

    @Override
    protected final InternalCompletableFuture<Boolean> doUnlock(long sessionId, long threadId, UUID invocationUid) {
        return this.invoke(new UnlockOp(this.objectName, sessionId, threadId, invocationUid));
    }

    @Override
    protected final InternalCompletableFuture<RaftLockOwnershipState> doGetLockOwnershipState() {
        return this.invoke(new GetLockOwnershipStateOp(this.objectName));
    }

    private <T> InternalCompletableFuture<T> invoke(RaftOp op) {
        return this.invocationManager.invoke(this.groupId, op);
    }

    @Override
    public void destroy() {
        try {
            this.invocationManager.invoke(this.groupId, new DestroyRaftObjectOp(this.getServiceName(), this.objectName)).join();
        }
        finally {
            super.destroy();
        }
    }
}

