/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.cp.internal.operation;

import com.atlassian.nutcluster.cp.internal.RaftService;
import com.atlassian.nutcluster.cp.internal.RaftServiceDataSerializerHook;
import com.atlassian.nutcluster.cp.internal.RaftSystemOperation;
import com.atlassian.nutcluster.nio.ObjectDataInput;
import com.atlassian.nutcluster.nio.ObjectDataOutput;
import com.atlassian.nutcluster.nio.serialization.IdentifiedDataSerializable;
import com.atlassian.nutcluster.spi.CallStatus;
import com.atlassian.nutcluster.spi.Offload;
import com.atlassian.nutcluster.spi.Operation;
import java.io.IOException;

public class RestartCPMemberOp
extends Operation
implements RaftSystemOperation,
IdentifiedDataSerializable {
    private long seed;

    public RestartCPMemberOp() {
    }

    public RestartCPMemberOp(long seed) {
        this.seed = seed;
    }

    @Override
    public CallStatus call() throws Exception {
        return new OffloadImpl();
    }

    @Override
    public final boolean validatesTarget() {
        return false;
    }

    @Override
    public final String getServiceName() {
        return "hz:core:raft";
    }

    @Override
    public int getFactoryId() {
        return RaftServiceDataSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return 40;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        out.writeLong(this.seed);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        this.seed = in.readLong();
    }

    private final class OffloadImpl
    extends Offload {
        private OffloadImpl() {
            super(RestartCPMemberOp.this);
        }

        @Override
        public void start() {
            RestartCPMemberOp.this.getNodeEngine().getExecutionService().execute("hz:system", new RestartLocalTask());
        }
    }

    private class RestartLocalTask
    implements Runnable {
        private RestartLocalTask() {
        }

        @Override
        public void run() {
            RaftService service = (RaftService)RestartCPMemberOp.this.getService();
            try {
                service.restartLocal(RestartCPMemberOp.this.seed);
                RestartCPMemberOp.this.sendResponse(null);
            }
            catch (Exception e) {
                RestartCPMemberOp.this.sendResponse(e);
            }
        }
    }
}

