/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.cp.internal.raft.impl.handler;

import com.atlassian.nutcluster.core.Endpoint;
import com.atlassian.nutcluster.cp.internal.raft.impl.RaftNodeImpl;
import com.atlassian.nutcluster.cp.internal.raft.impl.RaftRole;
import com.atlassian.nutcluster.cp.internal.raft.impl.dto.VoteRequest;
import com.atlassian.nutcluster.cp.internal.raft.impl.dto.VoteResponse;
import com.atlassian.nutcluster.cp.internal.raft.impl.log.RaftLog;
import com.atlassian.nutcluster.cp.internal.raft.impl.state.RaftState;
import com.atlassian.nutcluster.cp.internal.raft.impl.task.RaftNodeStatusAwareTask;
import com.atlassian.nutcluster.util.Clock;

public class VoteRequestHandlerTask
extends RaftNodeStatusAwareTask
implements Runnable {
    private final VoteRequest req;

    public VoteRequestHandlerTask(RaftNodeImpl raftNode, VoteRequest req) {
        super(raftNode);
        this.req = req;
    }

    @Override
    protected void innerRun() {
        RaftState state = this.raftNode.state();
        Endpoint localEndpoint = this.raftNode.getLocalMember();
        if (this.raftNode.lastAppendEntriesTimestamp() > Clock.currentTimeMillis() - this.raftNode.getLeaderElectionTimeoutInMillis()) {
            this.logger.info("Rejecting " + String.valueOf(this.req) + " since received append entries recently.");
            this.raftNode.send(new VoteResponse(localEndpoint, state.term(), false), this.req.candidate());
            return;
        }
        if (state.term() > this.req.term()) {
            this.logger.info("Rejecting " + String.valueOf(this.req) + " since current term: " + state.term() + " is bigger");
            this.raftNode.send(new VoteResponse(localEndpoint, state.term(), false), this.req.candidate());
            return;
        }
        if (state.term() < this.req.term()) {
            if (state.role() != RaftRole.FOLLOWER) {
                this.logger.info("Demoting to FOLLOWER after " + String.valueOf(this.req) + " since current term: " + state.term() + " is smaller");
            } else {
                this.logger.info("Moving to new term: " + this.req.term() + " from current term: " + state.term() + " after " + String.valueOf(this.req));
            }
            state.toFollower(this.req.term());
            this.raftNode.printMemberState();
        }
        if (state.leader() != null && !this.req.candidate().equals(state.leader())) {
            this.logger.warning("Rejecting " + String.valueOf(this.req) + " since we have a leader: " + String.valueOf(state.leader()));
            this.raftNode.send(new VoteResponse(localEndpoint, this.req.term(), false), this.req.candidate());
            return;
        }
        if (state.lastVoteTerm() == this.req.term() && state.votedFor() != null) {
            boolean granted = this.req.candidate().equals(state.votedFor());
            if (granted) {
                this.logger.info("Vote granted for duplicate" + String.valueOf(this.req));
            } else {
                this.logger.info("Duplicate " + String.valueOf(this.req) + ". currently voted-for: " + String.valueOf(state.votedFor()));
            }
            this.raftNode.send(new VoteResponse(localEndpoint, this.req.term(), granted), this.req.candidate());
            return;
        }
        RaftLog raftLog = state.log();
        if (raftLog.lastLogOrSnapshotTerm() > this.req.lastLogTerm()) {
            this.logger.info("Rejecting " + String.valueOf(this.req) + " since our last log term: " + raftLog.lastLogOrSnapshotTerm() + " is greater");
            this.raftNode.send(new VoteResponse(localEndpoint, this.req.term(), false), this.req.candidate());
            return;
        }
        if (raftLog.lastLogOrSnapshotTerm() == this.req.lastLogTerm() && raftLog.lastLogOrSnapshotIndex() > this.req.lastLogIndex()) {
            this.logger.info("Rejecting " + String.valueOf(this.req) + " since our last log index: " + raftLog.lastLogOrSnapshotIndex() + " is greater");
            this.raftNode.send(new VoteResponse(localEndpoint, this.req.term(), false), this.req.candidate());
            return;
        }
        this.logger.info("Granted vote for " + String.valueOf(this.req));
        state.persistVote(this.req.term(), this.req.candidate());
        this.raftNode.send(new VoteResponse(localEndpoint, this.req.term(), true), this.req.candidate());
    }
}

