/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.cp.internal.raftop.metadata;

import com.atlassian.nutcluster.cp.internal.CPMemberInfo;
import com.atlassian.nutcluster.cp.internal.IndeterminateOperationStateAware;
import com.atlassian.nutcluster.cp.internal.MetadataRaftGroupManager;
import com.atlassian.nutcluster.cp.internal.RaftServiceDataSerializerHook;
import com.atlassian.nutcluster.cp.internal.raft.impl.util.PostponedResponse;
import com.atlassian.nutcluster.cp.internal.raftop.metadata.MetadataRaftGroupOp;
import com.atlassian.nutcluster.nio.ObjectDataInput;
import com.atlassian.nutcluster.nio.ObjectDataOutput;
import com.atlassian.nutcluster.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;

public class RemoveCPMemberOp
extends MetadataRaftGroupOp
implements IndeterminateOperationStateAware,
IdentifiedDataSerializable {
    private CPMemberInfo member;

    public RemoveCPMemberOp() {
    }

    public RemoveCPMemberOp(CPMemberInfo member) {
        this.member = member;
    }

    @Override
    public Object run(MetadataRaftGroupManager metadataGroupManager, long commitIndex) {
        if (metadataGroupManager.removeMember(commitIndex, this.member)) {
            return null;
        }
        return PostponedResponse.INSTANCE;
    }

    @Override
    public boolean isRetryableOnIndeterminateOperationState() {
        return true;
    }

    @Override
    public int getFactoryId() {
        return RaftServiceDataSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return 16;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeObject(this.member);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.member = (CPMemberInfo)in.readObject();
    }

    @Override
    protected void toString(StringBuilder sb) {
        sb.append(", member=").append(this.member);
    }
}

