/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.durableexecutor.impl.operations;

import com.atlassian.nutcluster.durableexecutor.impl.operations.AbstractDurableExecutorOperation;
import com.atlassian.nutcluster.durableexecutor.impl.operations.DurableExecutorWaitNotifyKey;
import com.atlassian.nutcluster.durableexecutor.impl.operations.PutResultBackupOperation;
import com.atlassian.nutcluster.nio.Bits;
import com.atlassian.nutcluster.nio.ObjectDataInput;
import com.atlassian.nutcluster.nio.ObjectDataOutput;
import com.atlassian.nutcluster.spi.BackupAwareOperation;
import com.atlassian.nutcluster.spi.Notifier;
import com.atlassian.nutcluster.spi.Operation;
import com.atlassian.nutcluster.spi.WaitNotifyKey;
import java.io.IOException;

public class PutResultOperation
extends AbstractDurableExecutorOperation
implements Notifier,
BackupAwareOperation {
    private int sequence;
    private Object result;

    public PutResultOperation() {
    }

    public PutResultOperation(String name, int sequence, Object result) {
        super(name);
        this.sequence = sequence;
        this.result = result;
    }

    @Override
    public void run() throws Exception {
        this.getExecutorContainer().putResult(this.sequence, this.result);
    }

    @Override
    public boolean shouldNotify() {
        return true;
    }

    @Override
    public WaitNotifyKey getNotifiedKey() {
        long uniqueId = Bits.combineToLong(this.getPartitionId(), this.sequence);
        return new DurableExecutorWaitNotifyKey(this.name, uniqueId);
    }

    @Override
    public Operation getBackupOperation() {
        return new PutResultBackupOperation(this.name, this.sequence, this.result);
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeInt(this.sequence);
        out.writeObject(this.result);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.sequence = in.readInt();
        this.result = in.readObject();
    }

    @Override
    public int getId() {
        return 2;
    }
}

