/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.durableexecutor.impl.operations;

import com.atlassian.nutcluster.core.NutclusterException;
import com.atlassian.nutcluster.durableexecutor.impl.DurableExecutorContainer;
import com.atlassian.nutcluster.durableexecutor.impl.operations.DisposeResultOperation;
import com.atlassian.nutcluster.durableexecutor.impl.operations.DurableExecutorWaitNotifyKey;
import com.atlassian.nutcluster.nio.Bits;
import com.atlassian.nutcluster.spi.BlockingOperation;
import com.atlassian.nutcluster.spi.WaitNotifyKey;
import com.atlassian.nutcluster.spi.impl.MutatingOperation;

public class RetrieveAndDisposeResultOperation
extends DisposeResultOperation
implements BlockingOperation,
MutatingOperation {
    private transient Object result;

    public RetrieveAndDisposeResultOperation() {
    }

    public RetrieveAndDisposeResultOperation(String name, int sequence) {
        super(name, sequence);
    }

    @Override
    public void run() throws Exception {
        DurableExecutorContainer executorContainer = this.getExecutorContainer();
        this.result = executorContainer.retrieveAndDisposeResult(this.sequence);
    }

    @Override
    public Object getResponse() {
        return this.result;
    }

    @Override
    public WaitNotifyKey getWaitKey() {
        long uniqueId = Bits.combineToLong(this.getPartitionId(), this.sequence);
        return new DurableExecutorWaitNotifyKey(this.name, uniqueId);
    }

    @Override
    public boolean shouldWait() {
        DurableExecutorContainer executorContainer = this.getExecutorContainer();
        return executorContainer.shouldWait(this.sequence);
    }

    @Override
    public void onWaitExpire() {
        this.sendResponse(new NutclusterException());
    }

    @Override
    public int getId() {
        return 4;
    }
}

