/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.durableexecutor.impl.operations;

import com.atlassian.nutcluster.core.NutclusterException;
import com.atlassian.nutcluster.durableexecutor.impl.DurableExecutorContainer;
import com.atlassian.nutcluster.durableexecutor.impl.operations.AbstractDurableExecutorOperation;
import com.atlassian.nutcluster.durableexecutor.impl.operations.DurableExecutorWaitNotifyKey;
import com.atlassian.nutcluster.nio.Bits;
import com.atlassian.nutcluster.nio.ObjectDataInput;
import com.atlassian.nutcluster.nio.ObjectDataOutput;
import com.atlassian.nutcluster.spi.BlockingOperation;
import com.atlassian.nutcluster.spi.ReadonlyOperation;
import com.atlassian.nutcluster.spi.WaitNotifyKey;
import java.io.IOException;

public class RetrieveResultOperation
extends AbstractDurableExecutorOperation
implements BlockingOperation,
ReadonlyOperation {
    private int sequence;
    private transient Object result;

    public RetrieveResultOperation() {
    }

    public RetrieveResultOperation(String name, int sequence) {
        super(name);
        this.sequence = sequence;
    }

    @Override
    public void run() throws Exception {
        DurableExecutorContainer executorContainer = this.getExecutorContainer();
        this.result = executorContainer.retrieveResult(this.sequence);
    }

    @Override
    public Object getResponse() {
        return this.result;
    }

    @Override
    public WaitNotifyKey getWaitKey() {
        long uniqueId = Bits.combineToLong(this.getPartitionId(), this.sequence);
        return new DurableExecutorWaitNotifyKey(this.name, uniqueId);
    }

    @Override
    public boolean shouldWait() {
        DurableExecutorContainer executorContainer = this.getExecutorContainer();
        return executorContainer.shouldWait(this.sequence);
    }

    @Override
    public void onWaitExpire() {
        this.sendResponse(new NutclusterException());
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeInt(this.sequence);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.sequence = in.readInt();
    }

    @Override
    public int getId() {
        return 5;
    }
}

