/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.executor.impl;

import com.atlassian.nutcluster.core.NutclusterInstance;
import com.atlassian.nutcluster.core.NutclusterInstanceAware;
import com.atlassian.nutcluster.core.PartitionAware;
import com.atlassian.nutcluster.executor.impl.ExecutorDataSerializerHook;
import com.atlassian.nutcluster.nio.ObjectDataInput;
import com.atlassian.nutcluster.nio.ObjectDataOutput;
import com.atlassian.nutcluster.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;
import java.util.concurrent.Callable;

public final class RunnableAdapter<V>
implements IdentifiedDataSerializable,
Callable<V>,
NutclusterInstanceAware,
PartitionAware {
    private Runnable task;

    public RunnableAdapter() {
    }

    public RunnableAdapter(Runnable task) {
        this.task = task;
    }

    public Runnable getRunnable() {
        return this.task;
    }

    public void setRunnable(Runnable runnable) {
        this.task = runnable;
    }

    @Override
    public V call() throws Exception {
        this.task.run();
        return null;
    }

    public Object getPartitionKey() {
        if (this.task instanceof PartitionAware) {
            return ((PartitionAware)((Object)this.task)).getPartitionKey();
        }
        return null;
    }

    @Override
    public void setNutclusterInstance(NutclusterInstance NutclusterInstance2) {
        if (this.task instanceof NutclusterInstanceAware) {
            NutclusterInstanceAware instanceAwareTask = (NutclusterInstanceAware)((Object)this.task);
            instanceAwareTask.setNutclusterInstance(NutclusterInstance2);
        }
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeObject(this.task);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.task = (Runnable)in.readObject();
    }

    @Override
    public int getFactoryId() {
        return ExecutorDataSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return 2;
    }

    public String toString() {
        return "RunnableAdapter{task=" + String.valueOf(this.task) + "}";
    }
}

