/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.flakeidgen.impl;

import com.atlassian.nutcluster.core.DistributedObject;
import com.atlassian.nutcluster.flakeidgen.impl.FlakeIdGeneratorProxy;
import com.atlassian.nutcluster.monitor.LocalFlakeIdGeneratorStats;
import com.atlassian.nutcluster.monitor.impl.LocalFlakeIdGeneratorStatsImpl;
import com.atlassian.nutcluster.spi.ManagedService;
import com.atlassian.nutcluster.spi.NodeEngine;
import com.atlassian.nutcluster.spi.RemoteService;
import com.atlassian.nutcluster.spi.StatisticsAwareService;
import com.atlassian.nutcluster.util.ConcurrencyUtil;
import com.atlassian.nutcluster.util.ConstructorFunction;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;

public class FlakeIdGeneratorService
implements ManagedService,
RemoteService,
StatisticsAwareService<LocalFlakeIdGeneratorStats> {
    public static final String SERVICE_NAME = "hz:impl:flakeIdGeneratorService";
    private NodeEngine nodeEngine;
    private final ConcurrentHashMap<String, LocalFlakeIdGeneratorStatsImpl> statsMap = new ConcurrentHashMap();
    private final ConstructorFunction<String, LocalFlakeIdGeneratorStatsImpl> localFlakeIdStatsConstructorFunction = new ConstructorFunction<String, LocalFlakeIdGeneratorStatsImpl>(this){

        @Override
        public LocalFlakeIdGeneratorStatsImpl createNew(String key) {
            return new LocalFlakeIdGeneratorStatsImpl();
        }
    };

    public FlakeIdGeneratorService(NodeEngine nodeEngine) {
        this.nodeEngine = nodeEngine;
    }

    @Override
    public void init(NodeEngine nodeEngine, Properties properties) {
        this.nodeEngine = nodeEngine;
    }

    @Override
    public void reset() {
        this.statsMap.clear();
    }

    @Override
    public void shutdown(boolean terminate) {
        this.reset();
    }

    @Override
    public DistributedObject createDistributedObject(String name) {
        return new FlakeIdGeneratorProxy(name, this.nodeEngine, this);
    }

    @Override
    public void destroyDistributedObject(String name) {
        this.statsMap.remove(name);
    }

    @Override
    public Map<String, LocalFlakeIdGeneratorStats> getStats() {
        return new HashMap<String, LocalFlakeIdGeneratorStats>(this.statsMap);
    }

    public void updateStatsForBatch(String name, int batchSize) {
        this.getLocalFlakeIdStats(name).update(batchSize);
    }

    private LocalFlakeIdGeneratorStatsImpl getLocalFlakeIdStats(String name) {
        return ConcurrencyUtil.getOrPutIfAbsent(this.statsMap, name, this.localFlakeIdStatsConstructorFunction);
    }
}

