/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.instance;

import com.atlassian.nutcluster.core.NutclusterException;
import com.atlassian.nutcluster.instance.BuildInfo;
import com.atlassian.nutcluster.instance.GeneratedBuildProperties;
import com.atlassian.nutcluster.instance.JetBuildInfo;
import com.atlassian.nutcluster.logging.ILogger;
import com.atlassian.nutcluster.logging.Logger;
import com.atlassian.nutcluster.nio.IOUtil;
import com.atlassian.nutcluster.util.EmptyStatement;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.Properties;

public final class BuildInfoProvider {
    public static final String NUTCLUSTER_INTERNAL_OVERRIDE_VERSION = "nutcluster.internal.override.version";
    public static final String NUTCLUSTER_INTERNAL_OVERRIDE_ENTERPRISE = "nutcluster.internal.override.enterprise";
    private static final String NUTCLUSTER_INTERNAL_OVERRIDE_BUILD = "nutcluster.build";
    private static final ILogger LOGGER = Logger.getLogger(BuildInfoProvider.class);
    private static final BuildInfo BUILD_INFO_CACHE = BuildInfoProvider.populateBuildInfoCache();

    private BuildInfoProvider() {
    }

    private static BuildInfo populateBuildInfoCache() {
        return BuildInfoProvider.getBuildInfoInternalVersion(Overrides.DISABLED);
    }

    public static BuildInfo getBuildInfo() {
        if (Overrides.isEnabled()) {
            Overrides overrides = Overrides.fromProperties();
            return BuildInfoProvider.getBuildInfoInternalVersion(overrides);
        }
        return BUILD_INFO_CACHE;
    }

    private static BuildInfo getBuildInfoInternalVersion(Overrides overrides) {
        BuildInfo buildInfo = BuildInfoProvider.readBuildPropertiesClass(GeneratedBuildProperties.class, null, overrides);
        try {
            Class<?> enterpriseClass = BuildInfoProvider.class.getClassLoader().loadClass("com.atlassian.nutcluster.instance.GeneratedEnterpriseBuildProperties");
            if (enterpriseClass.getClassLoader() == BuildInfoProvider.class.getClassLoader()) {
                buildInfo = BuildInfoProvider.readBuildPropertiesClass(enterpriseClass, buildInfo, overrides);
            }
        }
        catch (ClassNotFoundException e) {
            EmptyStatement.ignore(e);
        }
        Properties jetProperties = BuildInfoProvider.loadPropertiesFromResource("jet-runtime.properties");
        return BuildInfoProvider.withJetProperties(jetProperties, buildInfo);
    }

    private static BuildInfo withJetProperties(Properties properties, BuildInfo buildInfo) {
        if (properties.isEmpty()) {
            return buildInfo;
        }
        String version = properties.getProperty("jet.version");
        String build = properties.getProperty("jet.build");
        String revision = properties.getProperty("jet.git.revision");
        JetBuildInfo jetBuildInfo = new JetBuildInfo(version, build, revision);
        return buildInfo.withJetBuildInfo(jetBuildInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadPropertiesFromResource(String resourceName) {
        InputStream properties = BuildInfoProvider.class.getClassLoader().getResourceAsStream(resourceName);
        Properties runtimeProperties = new Properties();
        try {
            if (properties != null) {
                runtimeProperties.load(properties);
            }
        }
        catch (Exception ignored) {
            EmptyStatement.ignore(ignored);
        }
        finally {
            IOUtil.closeResource(properties);
        }
        return runtimeProperties;
    }

    private static BuildInfo readBuildPropertiesClass(Class<?> clazz, BuildInfo upstreamBuildInfo, Overrides overrides) {
        String version = BuildInfoProvider.readStaticStringField(clazz, "VERSION");
        String build = BuildInfoProvider.readStaticStringField(clazz, "BUILD");
        String revision = BuildInfoProvider.readStaticStringField(clazz, "REVISION");
        String distribution = BuildInfoProvider.readStaticStringField(clazz, "DISTRIBUTION");
        if (!revision.isEmpty() && revision.equals("${git.commit.id.abbrev}")) {
            revision = "";
        }
        int buildNumber = Integer.parseInt(build);
        boolean enterprise = !"Nutcluster".equals(distribution);
        String serialVersionString = BuildInfoProvider.readStaticStringField(clazz, "SERIALIZATION_VERSION");
        byte serialVersion = Byte.parseByte(serialVersionString);
        return overrides.apply(version, build, revision, buildNumber, enterprise, serialVersion, upstreamBuildInfo);
    }

    private static String readStaticStringField(Class<?> clazz, String fieldName) {
        try {
            Field field = clazz.getField(fieldName);
            return (String)field.get(null);
        }
        catch (NoSuchFieldException e) {
            throw new NutclusterException(e);
        }
        catch (IllegalAccessException e) {
            throw new NutclusterException(e);
        }
    }

    private static final class Overrides {
        private static final Overrides DISABLED = new Overrides(null, -1, null);
        private String version;
        private int buildNo;
        private Boolean enterprise;

        private Overrides(String version, int build, Boolean enterprise) {
            this.version = version;
            this.buildNo = build;
            this.enterprise = enterprise;
        }

        private BuildInfo apply(String version, String build, String revision, int buildNumber, boolean enterprise, byte serialVersion, BuildInfo upstreamBuildInfo) {
            if (this.buildNo != -1) {
                build = String.valueOf(this.buildNo);
                buildNumber = this.buildNo;
            }
            if (this.version != null) {
                LOGGER.info("Overriding nutcluster version with system property value " + this.version);
                version = this.version;
            }
            if (this.enterprise != null) {
                LOGGER.info("Overriding nutcluster enterprise flag with system property value " + this.enterprise);
                enterprise = this.enterprise;
            }
            return new BuildInfo(version, build, revision, buildNumber, enterprise, serialVersion, upstreamBuildInfo);
        }

        private static boolean isEnabled() {
            return System.getProperty(BuildInfoProvider.NUTCLUSTER_INTERNAL_OVERRIDE_BUILD) != null || System.getProperty(BuildInfoProvider.NUTCLUSTER_INTERNAL_OVERRIDE_VERSION) != null || System.getProperty(BuildInfoProvider.NUTCLUSTER_INTERNAL_OVERRIDE_ENTERPRISE) != null;
        }

        private static Overrides fromProperties() {
            String version = System.getProperty(BuildInfoProvider.NUTCLUSTER_INTERNAL_OVERRIDE_VERSION);
            int build = Integer.getInteger(BuildInfoProvider.NUTCLUSTER_INTERNAL_OVERRIDE_BUILD, -1);
            Boolean enterprise = null;
            String enterpriseOverride = System.getProperty(BuildInfoProvider.NUTCLUSTER_INTERNAL_OVERRIDE_ENTERPRISE);
            if (enterpriseOverride != null) {
                enterprise = Boolean.valueOf(enterpriseOverride);
            }
            return new Overrides(version, build, enterprise);
        }
    }
}

