/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.instance;

import com.atlassian.nutcluster.cluster.Joiner;
import com.atlassian.nutcluster.config.Config;
import com.atlassian.nutcluster.config.ConfigAccessor;
import com.atlassian.nutcluster.config.ConfigurationException;
import com.atlassian.nutcluster.config.MemberAddressProviderConfig;
import com.atlassian.nutcluster.instance.AddressPicker;
import com.atlassian.nutcluster.instance.AdvancedNetworkAddressPicker;
import com.atlassian.nutcluster.instance.DefaultAddressPicker;
import com.atlassian.nutcluster.instance.DelegatingAddressPicker;
import com.atlassian.nutcluster.instance.Node;
import com.atlassian.nutcluster.instance.NodeContext;
import com.atlassian.nutcluster.instance.NodeExtension;
import com.atlassian.nutcluster.instance.NodeExtensionFactory;
import com.atlassian.nutcluster.internal.networking.Networking;
import com.atlassian.nutcluster.internal.networking.ServerSocketRegistry;
import com.atlassian.nutcluster.internal.networking.nio.NioNetworking;
import com.atlassian.nutcluster.internal.util.InstantiationUtils;
import com.atlassian.nutcluster.logging.ILogger;
import com.atlassian.nutcluster.logging.LoggingServiceImpl;
import com.atlassian.nutcluster.nio.ClassLoaderUtil;
import com.atlassian.nutcluster.nio.NetworkingService;
import com.atlassian.nutcluster.nio.NodeIOService;
import com.atlassian.nutcluster.nio.tcp.TcpIpConnectionChannelErrorHandler;
import com.atlassian.nutcluster.nio.tcp.TcpIpNetworkingService;
import com.atlassian.nutcluster.spi.MemberAddressProvider;
import com.atlassian.nutcluster.spi.annotation.PrivateApi;
import com.atlassian.nutcluster.spi.properties.GroupProperty;
import com.atlassian.nutcluster.spi.properties.NutclusterProperties;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;

@PrivateApi
public class DefaultNodeContext
implements NodeContext {
    public static final List<String> EXTENSION_PRIORITY_LIST = Collections.unmodifiableList(Arrays.asList("com.atlassian.nutcluster.instance.EnterpriseNodeExtension", "com.atlassian.nutcluster.instance.DefaultNodeExtension"));

    @Override
    public NodeExtension createNodeExtension(Node node) {
        return NodeExtensionFactory.create(node, EXTENSION_PRIORITY_LIST);
    }

    @Override
    public AddressPicker createAddressPicker(Node node) {
        Config config = node.getConfig();
        MemberAddressProviderConfig memberAddressProviderConfig = ConfigAccessor.getActiveMemberNetworkConfig(config).getMemberAddressProviderConfig();
        ILogger addressPickerLogger = node.getLogger(AddressPicker.class);
        if (!memberAddressProviderConfig.isEnabled()) {
            if (config.getAdvancedNetworkConfig().isEnabled()) {
                return new AdvancedNetworkAddressPicker(config, addressPickerLogger);
            }
            return new DefaultAddressPicker(config, addressPickerLogger);
        }
        MemberAddressProvider implementation = memberAddressProviderConfig.getImplementation();
        if (implementation != null) {
            return new DelegatingAddressPicker(implementation, config, addressPickerLogger);
        }
        ClassLoader classLoader = config.getClassLoader();
        String classname = memberAddressProviderConfig.getClassName();
        Class<? extends MemberAddressProvider> clazz = this.loadMemberAddressProviderClass(classLoader, classname);
        ILogger memberAddressProviderLogger = node.getLogger(clazz);
        Properties properties = memberAddressProviderConfig.getProperties();
        MemberAddressProvider memberAddressProvider = DefaultNodeContext.newMemberAddressProviderInstance(clazz, memberAddressProviderLogger, properties);
        return new DelegatingAddressPicker(memberAddressProvider, config, addressPickerLogger);
    }

    private static MemberAddressProvider newMemberAddressProviderInstance(Class<? extends MemberAddressProvider> clazz, ILogger logger, Properties properties) {
        Properties nonNullProps = properties == null ? new Properties() : properties;
        MemberAddressProvider provider = InstantiationUtils.newInstanceOrNull(clazz, nonNullProps, logger);
        if (provider == null) {
            provider = InstantiationUtils.newInstanceOrNull(clazz, logger, nonNullProps);
        }
        if (provider == null) {
            provider = InstantiationUtils.newInstanceOrNull(clazz, nonNullProps);
        }
        if (provider == null) {
            if (properties != null && !properties.isEmpty()) {
                throw new ConfigurationException("Cannot find a matching constructor for MemberAddressProvider.  The member address provider has properties configured, but the class '" + clazz.getName() + "' does not have a public constructor accepting properties.");
            }
            provider = InstantiationUtils.newInstanceOrNull(clazz, logger);
        }
        if (provider == null) {
            provider = InstantiationUtils.newInstanceOrNull(clazz, new Object[0]);
        }
        if (provider == null) {
            throw new ConfigurationException("Cannot find a matching constructor for MemberAddressProvider implementation '" + clazz.getName() + "'.");
        }
        return provider;
    }

    private Class<? extends MemberAddressProvider> loadMemberAddressProviderClass(ClassLoader classLoader, String classname) {
        try {
            Class<?> clazz = ClassLoaderUtil.loadClass(classLoader, classname);
            if (!MemberAddressProvider.class.isAssignableFrom(clazz)) {
                throw new ConfigurationException("Configured member address provider " + clazz.getName() + " does not implement the interface" + MemberAddressProvider.class.getName());
            }
            return clazz;
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationException("Cannot create a new instance of MemberAddressProvider '" + classname + "'", e);
        }
    }

    @Override
    public Joiner createJoiner(Node node) {
        return node.createJoiner();
    }

    @Override
    public NetworkingService createNetworkingService(Node node, ServerSocketRegistry registry) {
        NodeIOService ioService = new NodeIOService(node, node.nodeEngine);
        Networking networking = this.createNetworking(node);
        Config config = node.getConfig();
        return new TcpIpNetworkingService(config, ioService, registry, node.loggingService, node.nodeEngine.getMetricsRegistry(), networking, node.getNodeExtension().createChannelInitializerProvider(ioService), node.getProperties());
    }

    private Networking createNetworking(Node node) {
        LoggingServiceImpl loggingService = node.loggingService;
        TcpIpConnectionChannelErrorHandler errorHandler = new TcpIpConnectionChannelErrorHandler(loggingService.getLogger(TcpIpConnectionChannelErrorHandler.class));
        NutclusterProperties props = node.getProperties();
        return new NioNetworking(new NioNetworking.Context().loggingService(loggingService).metricsRegistry(node.nodeEngine.getMetricsRegistry()).threadNamePrefix(node.nutclusterInstance.getName()).errorHandler(errorHandler).inputThreadCount(props.getInteger(GroupProperty.IO_INPUT_THREAD_COUNT)).outputThreadCount(props.getInteger(GroupProperty.IO_OUTPUT_THREAD_COUNT)).balancerIntervalSeconds(props.getInteger(GroupProperty.IO_BALANCER_INTERVAL_SECONDS)));
    }
}

