/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.instance;

import com.atlassian.nutcluster.cache.impl.CacheService;
import com.atlassian.nutcluster.cache.impl.ICacheService;
import com.atlassian.nutcluster.cluster.ClusterState;
import com.atlassian.nutcluster.config.Config;
import com.atlassian.nutcluster.config.ConfigAccessor;
import com.atlassian.nutcluster.config.SecurityConfig;
import com.atlassian.nutcluster.config.SerializationConfig;
import com.atlassian.nutcluster.config.SocketInterceptorConfig;
import com.atlassian.nutcluster.config.SymmetricEncryptionConfig;
import com.atlassian.nutcluster.core.NutclusterInstanceAware;
import com.atlassian.nutcluster.core.NutclusterInstanceNotActiveException;
import com.atlassian.nutcluster.core.PartitioningStrategy;
import com.atlassian.nutcluster.hotrestart.HotRestartService;
import com.atlassian.nutcluster.hotrestart.InternalHotRestartService;
import com.atlassian.nutcluster.hotrestart.NoOpHotRestartService;
import com.atlassian.nutcluster.hotrestart.NoopInternalHotRestartService;
import com.atlassian.nutcluster.instance.BuildInfo;
import com.atlassian.nutcluster.instance.BuildInfoProvider;
import com.atlassian.nutcluster.instance.EndpointQualifier;
import com.atlassian.nutcluster.instance.Node;
import com.atlassian.nutcluster.instance.NodeExtension;
import com.atlassian.nutcluster.instance.NutclusterInstanceImpl;
import com.atlassian.nutcluster.internal.ascii.TextCommandService;
import com.atlassian.nutcluster.internal.ascii.TextCommandServiceImpl;
import com.atlassian.nutcluster.internal.cluster.ClusterStateListener;
import com.atlassian.nutcluster.internal.cluster.ClusterVersionListener;
import com.atlassian.nutcluster.internal.cluster.impl.JoinMessage;
import com.atlassian.nutcluster.internal.cluster.impl.VersionMismatchException;
import com.atlassian.nutcluster.internal.diagnostics.BuildInfoPlugin;
import com.atlassian.nutcluster.internal.diagnostics.ConfigPropertiesPlugin;
import com.atlassian.nutcluster.internal.diagnostics.Diagnostics;
import com.atlassian.nutcluster.internal.diagnostics.EventQueuePlugin;
import com.atlassian.nutcluster.internal.diagnostics.InvocationPlugin;
import com.atlassian.nutcluster.internal.diagnostics.MemberHeartbeatPlugin;
import com.atlassian.nutcluster.internal.diagnostics.MemberNutclusterInstanceInfoPlugin;
import com.atlassian.nutcluster.internal.diagnostics.MetricsPlugin;
import com.atlassian.nutcluster.internal.diagnostics.NetworkingImbalancePlugin;
import com.atlassian.nutcluster.internal.diagnostics.OperationHeartbeatPlugin;
import com.atlassian.nutcluster.internal.diagnostics.OperationThreadSamplerPlugin;
import com.atlassian.nutcluster.internal.diagnostics.OverloadedConnectionsPlugin;
import com.atlassian.nutcluster.internal.diagnostics.PendingInvocationsPlugin;
import com.atlassian.nutcluster.internal.diagnostics.SlowOperationPlugin;
import com.atlassian.nutcluster.internal.diagnostics.StoreLatencyPlugin;
import com.atlassian.nutcluster.internal.diagnostics.SystemLogPlugin;
import com.atlassian.nutcluster.internal.diagnostics.SystemPropertiesPlugin;
import com.atlassian.nutcluster.internal.dynamicconfig.DynamicConfigListener;
import com.atlassian.nutcluster.internal.dynamicconfig.EmptyDynamicConfigListener;
import com.atlassian.nutcluster.internal.jmx.ManagementService;
import com.atlassian.nutcluster.internal.management.ManagementCenterConnectionFactory;
import com.atlassian.nutcluster.internal.management.TimedMemberStateFactory;
import com.atlassian.nutcluster.internal.networking.ChannelInitializerProvider;
import com.atlassian.nutcluster.internal.networking.InboundHandler;
import com.atlassian.nutcluster.internal.networking.OutboundHandler;
import com.atlassian.nutcluster.internal.serialization.InternalSerializationService;
import com.atlassian.nutcluster.internal.serialization.impl.DefaultSerializationServiceBuilder;
import com.atlassian.nutcluster.logging.ILogger;
import com.atlassian.nutcluster.map.impl.MapService;
import com.atlassian.nutcluster.map.impl.MapServiceConstructor;
import com.atlassian.nutcluster.memory.DefaultMemoryStats;
import com.atlassian.nutcluster.memory.MemoryStats;
import com.atlassian.nutcluster.nio.Address;
import com.atlassian.nutcluster.nio.ClassLoaderUtil;
import com.atlassian.nutcluster.nio.IOService;
import com.atlassian.nutcluster.nio.MemberSocketInterceptor;
import com.atlassian.nutcluster.nio.tcp.DefaultChannelInitializerProvider;
import com.atlassian.nutcluster.nio.tcp.PacketDecoder;
import com.atlassian.nutcluster.nio.tcp.PacketEncoder;
import com.atlassian.nutcluster.nio.tcp.TcpIpConnection;
import com.atlassian.nutcluster.partition.strategy.DefaultPartitioningStrategy;
import com.atlassian.nutcluster.security.SecurityContext;
import com.atlassian.nutcluster.security.SecurityService;
import com.atlassian.nutcluster.spi.NodeEngine;
import com.atlassian.nutcluster.spi.annotation.PrivateApi;
import com.atlassian.nutcluster.spi.impl.NodeEngineImpl;
import com.atlassian.nutcluster.spi.impl.eventservice.impl.EventServiceImpl;
import com.atlassian.nutcluster.spi.impl.servicemanager.ServiceManager;
import com.atlassian.nutcluster.spi.properties.GroupProperty;
import com.atlassian.nutcluster.util.ByteArrayProcessor;
import com.atlassian.nutcluster.util.ConstructorFunction;
import com.atlassian.nutcluster.util.ExceptionUtil;
import com.atlassian.nutcluster.util.PhoneHome;
import com.atlassian.nutcluster.util.Preconditions;
import com.atlassian.nutcluster.util.UuidUtil;
import com.atlassian.nutcluster.util.function.Supplier;
import com.atlassian.nutcluster.version.MemberVersion;
import com.atlassian.nutcluster.version.Version;
import com.atlassian.nutcluster.wan.WanReplicationService;
import com.atlassian.nutcluster.wan.impl.WanReplicationServiceImpl;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

@PrivateApi
public class DefaultNodeExtension
implements NodeExtension {
    protected final Node node;
    protected final ILogger logger;
    protected final ILogger systemLogger;
    protected final List<ClusterVersionListener> clusterVersionListeners = new CopyOnWriteArrayList<ClusterVersionListener>();
    protected PhoneHome phoneHome;
    private final MemoryStats memoryStats = new DefaultMemoryStats();
    private MemberSocketInterceptor memberSocketInterceptor;

    public DefaultNodeExtension(Node node) {
        this.node = node;
        this.logger = node.getLogger(NodeExtension.class);
        this.systemLogger = node.getLogger("com.hazelcast.system");
        this.checkSecurityAllowed();
        this.createAndSetPhoneHome();
    }

    private void checkSecurityAllowed() {
        SecurityConfig securityConfig = this.node.getConfig().getSecurityConfig();
        if (securityConfig != null && securityConfig.isEnabled() && !BuildInfoProvider.getBuildInfo().isEnterprise()) {
            throw new IllegalStateException("Security requires Nutcluster Enterprise Edition");
        }
        SymmetricEncryptionConfig symmetricEncryptionConfig = ConfigAccessor.getActiveMemberNetworkConfig(this.node.getConfig()).getSymmetricEncryptionConfig();
        if (symmetricEncryptionConfig != null && symmetricEncryptionConfig.isEnabled() && !BuildInfoProvider.getBuildInfo().isEnterprise()) {
            throw new IllegalStateException("Symmetric Encryption requires Nutcluster Enterprise Edition");
        }
    }

    @Override
    public void beforeStart() {
        SocketInterceptorConfig config = this.node.getConfig().getNetworkConfig().getSocketInterceptorConfig();
        if (config != null && config.isEnabled()) {
            this.memberSocketInterceptor = this.createInterceptor(config);
        }
    }

    private MemberSocketInterceptor createInterceptor(SocketInterceptorConfig config) {
        MemberSocketInterceptor interceptor = (MemberSocketInterceptor)config.getImplementation();
        if (interceptor != null) {
            return interceptor;
        }
        try {
            interceptor = (MemberSocketInterceptor)ClassLoaderUtil.newInstance(this.node.getConfigClassLoader(), config.getClassName());
            interceptor.init(config.getProperties());
            if (interceptor instanceof NutclusterInstanceAware) {
                ((NutclusterInstanceAware)((Object)interceptor)).setNutclusterInstance(this.node.nutclusterInstance);
            }
        }
        catch (Exception e) {
            this.logger.warning("Failed to instantiate MemberSocketInterceptor", e);
        }
        return interceptor;
    }

    @Override
    public void printNodeInfo() {
        BuildInfo buildInfo = this.node.getBuildInfo();
        Object build = buildInfo.getBuild();
        String revision = buildInfo.getRevision();
        if (!revision.isEmpty()) {
            build = (String)build + " - " + revision;
        }
        this.systemLogger.info("Nutcluster " + buildInfo.getVersion() + " (" + (String)build + ") starting at " + String.valueOf(this.node.getThisAddress()));
        this.systemLogger.info("Copyright (c) 2008-2020, Hazelcast Inc. All Rights Reserved.");
        this.systemLogger.fine("Configured Nutcluster Serialization version: " + buildInfo.getSerializationVersion());
    }

    @Override
    public void beforeJoin() {
    }

    @Override
    public void afterStart() {
    }

    @Override
    public boolean isStartCompleted() {
        return this.node.getClusterService().isJoined();
    }

    @Override
    public SecurityContext getSecurityContext() {
        this.logger.warning("Security features are only available on Nutcluster Enterprise!");
        return null;
    }

    @Override
    public InternalSerializationService createSerializationService() {
        InternalSerializationService ss;
        try {
            Config config = this.node.getConfig();
            ClassLoader configClassLoader = this.node.getConfigClassLoader();
            NutclusterInstanceImpl NutclusterInstance2 = this.node.nutclusterInstance;
            PartitioningStrategy partitioningStrategy = this.getPartitioningStrategy(configClassLoader);
            DefaultSerializationServiceBuilder builder = new DefaultSerializationServiceBuilder();
            SerializationConfig serializationConfig = config.getSerializationConfig() != null ? config.getSerializationConfig() : new SerializationConfig();
            byte version = (byte)this.node.getProperties().getInteger(GroupProperty.SERIALIZATION_VERSION);
            ss = (InternalSerializationService)builder.setClassLoader(configClassLoader).setConfig(serializationConfig).setManagedContext(NutclusterInstance2.managedContext).setPartitioningStrategy(partitioningStrategy).setNutclusterInstance(NutclusterInstance2).setVersion(version).setNotActiveExceptionSupplier(new Supplier<RuntimeException>(this){

                @Override
                public RuntimeException get() {
                    return new NutclusterInstanceNotActiveException();
                }
            }).build();
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
        return ss;
    }

    @Override
    public SecurityService getSecurityService() {
        return null;
    }

    protected PartitioningStrategy getPartitioningStrategy(ClassLoader configClassLoader) throws Exception {
        String partitioningStrategyClassName = this.node.getProperties().getString(GroupProperty.PARTITIONING_STRATEGY_CLASS);
        if (partitioningStrategyClassName != null && partitioningStrategyClassName.length() > 0) {
            return (PartitioningStrategy)ClassLoaderUtil.newInstance(configClassLoader, partitioningStrategyClassName);
        }
        return new DefaultPartitioningStrategy();
    }

    @Override
    public <T> T createService(Class<T> clazz) {
        if (WanReplicationService.class.isAssignableFrom(clazz)) {
            return (T)new WanReplicationServiceImpl(this.node);
        }
        if (ICacheService.class.isAssignableFrom(clazz)) {
            return (T)new CacheService();
        }
        if (MapService.class.isAssignableFrom(clazz)) {
            return this.createMapService();
        }
        throw new IllegalArgumentException("Unknown service class: " + String.valueOf(clazz));
    }

    private <T> T createMapService() {
        ConstructorFunction<NodeEngine, MapService> constructor = MapServiceConstructor.getDefaultMapServiceConstructor();
        NodeEngineImpl nodeEngine = this.node.getNodeEngine();
        return (T)constructor.createNew(nodeEngine);
    }

    @Override
    public Map<String, Object> createExtensionServices() {
        return Collections.emptyMap();
    }

    @Override
    public MemberSocketInterceptor getSocketInterceptor(EndpointQualifier endpointQualifier) {
        return this.memberSocketInterceptor;
    }

    @Override
    public InboundHandler[] createInboundHandlers(EndpointQualifier qualifier, TcpIpConnection connection, IOService ioService) {
        NodeEngineImpl nodeEngine = this.node.nodeEngine;
        PacketDecoder decoder = new PacketDecoder(connection, nodeEngine.getPacketDispatcher());
        return new InboundHandler[]{decoder};
    }

    @Override
    public OutboundHandler[] createOutboundHandlers(EndpointQualifier qualifier, TcpIpConnection connection, IOService ioService) {
        return new OutboundHandler[]{new PacketEncoder()};
    }

    @Override
    public ChannelInitializerProvider createChannelInitializerProvider(IOService ioService) {
        DefaultChannelInitializerProvider provider = new DefaultChannelInitializerProvider(ioService, this.node.getConfig());
        provider.init();
        return provider;
    }

    @Override
    public void onThreadStart(Thread thread) {
    }

    @Override
    public void onThreadStop(Thread thread) {
    }

    @Override
    public MemoryStats getMemoryStats() {
        return this.memoryStats;
    }

    @Override
    public void beforeShutdown() {
    }

    @Override
    public void shutdown() {
        this.logger.info("Destroying node NodeExtension.");
        if (this.phoneHome != null) {
            this.phoneHome.shutdown();
        }
    }

    @Override
    public void validateJoinRequest(JoinMessage joinMessage) {
        MemberVersion memberVersion = joinMessage.getMemberVersion();
        Version clusterVersion = this.node.getClusterService().getClusterVersion();
        if (!memberVersion.asVersion().equals(clusterVersion)) {
            String msg = "Joining node's version " + String.valueOf(memberVersion) + " is not compatible with cluster version " + String.valueOf(clusterVersion);
            if (clusterVersion.getMajor() != memberVersion.getMajor()) {
                msg = msg + " (Rolling Member Upgrades are only supported for the same major version)";
            }
            if (clusterVersion.getMinor() > memberVersion.getMinor()) {
                msg = msg + " (Rolling Member Upgrades are only supported for the next minor version)";
            }
            if (!BuildInfoProvider.getBuildInfo().isEnterprise()) {
                msg = msg + " (Rolling Member Upgrades are only supported in Nutcluster Enterprise)";
            }
            throw new VersionMismatchException(msg);
        }
    }

    @Override
    public void beforeClusterStateChange(ClusterState currState, ClusterState requestedState, boolean isTransient) {
    }

    @Override
    public void onClusterStateChange(ClusterState newState, boolean isTransient) {
        ServiceManager serviceManager = this.node.getNodeEngine().getServiceManager();
        List<ClusterStateListener> listeners = serviceManager.getServices(ClusterStateListener.class);
        for (ClusterStateListener listener : listeners) {
            listener.onClusterStateChange(newState);
        }
    }

    @Override
    public void afterClusterStateChange(ClusterState oldState, ClusterState newState, boolean isTransient) {
    }

    @Override
    public void onPartitionStateChange() {
        if (this.node.clientEngine.getPartitionListenerService() != null) {
            this.node.clientEngine.getPartitionListenerService().onPartitionStateChange();
        }
    }

    @Override
    public void onMemberListChange() {
    }

    @Override
    public void onInitialClusterState(ClusterState initialState) {
    }

    @Override
    public void onClusterVersionChange(Version newVersion) {
        if (!this.node.getVersion().asVersion().isEqualTo(newVersion)) {
            this.systemLogger.info("Cluster version set to " + String.valueOf(newVersion));
        }
        ServiceManager serviceManager = this.node.getNodeEngine().getServiceManager();
        List<ClusterVersionListener> listeners = serviceManager.getServices(ClusterVersionListener.class);
        for (ClusterVersionListener listener : listeners) {
            listener.onClusterVersionChange(newVersion);
        }
        for (ClusterVersionListener listener : this.clusterVersionListeners) {
            listener.onClusterVersionChange(newVersion);
        }
    }

    @Override
    public boolean isNodeVersionCompatibleWith(Version clusterVersion) {
        Preconditions.checkNotNull(clusterVersion);
        return this.node.getVersion().asVersion().equals(clusterVersion);
    }

    @Override
    public boolean registerListener(Object listener) {
        if (listener instanceof NutclusterInstanceAware) {
            ((NutclusterInstanceAware)listener).setNutclusterInstance(this.node.nutclusterInstance);
        }
        if (listener instanceof ClusterVersionListener) {
            ClusterVersionListener clusterVersionListener = (ClusterVersionListener)listener;
            this.clusterVersionListeners.add(clusterVersionListener);
            clusterVersionListener.onClusterVersionChange(this.getClusterOrNodeVersion());
            return true;
        }
        return false;
    }

    @Override
    public HotRestartService getHotRestartService() {
        return new NoOpHotRestartService();
    }

    @Override
    public InternalHotRestartService getInternalHotRestartService() {
        return new NoopInternalHotRestartService();
    }

    @Override
    public String createMemberUuid(Address address) {
        return UuidUtil.createMemberUuid(address);
    }

    @Override
    public ByteArrayProcessor createMulticastInputProcessor(IOService ioService) {
        return null;
    }

    @Override
    public ByteArrayProcessor createMulticastOutputProcessor(IOService ioService) {
        return null;
    }

    private Version getClusterOrNodeVersion() {
        if (this.node.getClusterService() != null && !this.node.getClusterService().getClusterVersion().isUnknown()) {
            return this.node.getClusterService().getClusterVersion();
        }
        String overriddenClusterVersion = this.node.getProperties().getString(GroupProperty.INIT_CLUSTER_VERSION);
        return overriddenClusterVersion != null ? MemberVersion.of(overriddenClusterVersion).asVersion() : this.node.getVersion().asVersion();
    }

    @Override
    public TimedMemberStateFactory createTimedMemberStateFactory(NutclusterInstanceImpl instance) {
        return new TimedMemberStateFactory(instance);
    }

    @Override
    public DynamicConfigListener createDynamicConfigListener() {
        return new EmptyDynamicConfigListener();
    }

    @Override
    public void registerPlugins(Diagnostics diagnostics) {
        NodeEngineImpl nodeEngine = this.node.nodeEngine;
        diagnostics.register(new BuildInfoPlugin(nodeEngine));
        diagnostics.register(new SystemPropertiesPlugin(nodeEngine));
        diagnostics.register(new ConfigPropertiesPlugin(nodeEngine));
        diagnostics.register(new OverloadedConnectionsPlugin(nodeEngine));
        diagnostics.register(new EventQueuePlugin(nodeEngine, ((EventServiceImpl)nodeEngine.getEventService()).getEventExecutor()));
        diagnostics.register(new PendingInvocationsPlugin(nodeEngine));
        diagnostics.register(new MetricsPlugin(nodeEngine));
        diagnostics.register(new SlowOperationPlugin(nodeEngine));
        diagnostics.register(new InvocationPlugin(nodeEngine));
        diagnostics.register(new MemberNutclusterInstanceInfoPlugin(nodeEngine));
        diagnostics.register(new SystemLogPlugin(nodeEngine));
        diagnostics.register(new StoreLatencyPlugin(nodeEngine));
        diagnostics.register(new MemberHeartbeatPlugin(nodeEngine));
        diagnostics.register(new NetworkingImbalancePlugin(nodeEngine));
        diagnostics.register(new OperationHeartbeatPlugin(nodeEngine));
        diagnostics.register(new OperationThreadSamplerPlugin(nodeEngine));
    }

    @Override
    public ManagementCenterConnectionFactory getManagementCenterConnectionFactory() {
        return null;
    }

    @Override
    public ManagementService createJMXManagementService(NutclusterInstanceImpl instance) {
        return new ManagementService(instance);
    }

    @Override
    public TextCommandService createTextCommandService() {
        return new TextCommandServiceImpl(this.node);
    }

    @Override
    public void sendPhoneHome() {
        this.phoneHome.check(this.node);
    }

    @Override
    public void scheduleClusterVersionAutoUpgrade() {
    }

    @Override
    public boolean isClientFailoverSupported() {
        return false;
    }

    protected void createAndSetPhoneHome() {
        this.phoneHome = new PhoneHome(this.node);
    }

    public void setLicenseKey(String licenseKey) {
    }
}

