/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.instance;

import com.atlassian.nutcluster.cache.ICache;
import com.atlassian.nutcluster.core.ICacheManager;
import com.atlassian.nutcluster.core.NutclusterException;
import com.atlassian.nutcluster.instance.NutclusterInstanceImpl;
import com.atlassian.nutcluster.spi.exception.ServiceNotFoundException;
import com.atlassian.nutcluster.util.Preconditions;

public class NutclusterInstanceCacheManager
implements ICacheManager {
    private final NutclusterInstanceImpl original;

    public NutclusterInstanceCacheManager(NutclusterInstanceImpl original) {
        this.original = original;
    }

    @Override
    public <K, V> ICache<K, V> getCache(String name) {
        Preconditions.checkNotNull(name, "Retrieving a cache instance with a null name is not allowed!");
        return this.getCacheByFullName("/hz/" + name);
    }

    public <K, V> ICache<K, V> getCacheByFullName(String fullName) {
        Preconditions.checkNotNull(fullName, "Retrieving a cache instance with a null name is not allowed!");
        try {
            return (ICache)this.original.getDistributedObject("hz:impl:cacheService", fullName);
        }
        catch (NutclusterException e) {
            if (e.getCause() instanceof ServiceNotFoundException) {
                throw new IllegalStateException("There is no valid JCache API library at classpath. Please be sure that there is a JCache API library in your classpath and it is newer than `0.x` and `1.0.0-PFD` versions!");
            }
            throw e;
        }
    }
}

