/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.instance;

import com.atlassian.nutcluster.config.Config;
import com.atlassian.nutcluster.config.XmlConfigBuilder;
import com.atlassian.nutcluster.core.DuplicateInstanceNameException;
import com.atlassian.nutcluster.core.LifecycleEvent;
import com.atlassian.nutcluster.core.Member;
import com.atlassian.nutcluster.core.NutclusterInstance;
import com.atlassian.nutcluster.instance.DefaultNodeContext;
import com.atlassian.nutcluster.instance.Node;
import com.atlassian.nutcluster.instance.NodeContext;
import com.atlassian.nutcluster.instance.NutclusterInstanceImpl;
import com.atlassian.nutcluster.instance.NutclusterInstanceProxy;
import com.atlassian.nutcluster.instance.OutOfMemoryErrorDispatcher;
import com.atlassian.nutcluster.internal.jmx.ManagementService;
import com.atlassian.nutcluster.internal.util.ModularJavaUtils;
import com.atlassian.nutcluster.logging.Logger;
import com.atlassian.nutcluster.spi.annotation.PrivateApi;
import com.atlassian.nutcluster.spi.properties.GroupProperty;
import com.atlassian.nutcluster.util.EmptyStatement;
import com.atlassian.nutcluster.util.ExceptionUtil;
import com.atlassian.nutcluster.util.Preconditions;
import com.atlassian.nutcluster.util.SetUtil;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

@PrivateApi
public final class NutclusterInstanceFactory {
    private static final int ADDITIONAL_SLEEP_SECONDS_FOR_NON_FIRST_MEMBERS = 4;
    private static final AtomicInteger FACTORY_ID_GEN = new AtomicInteger();
    private static final ConcurrentMap<String, InstanceFuture<NutclusterInstanceProxy>> INSTANCE_MAP = new ConcurrentHashMap<String, InstanceFuture<NutclusterInstanceProxy>>(5);

    private NutclusterInstanceFactory() {
    }

    public static Set<NutclusterInstance> getAllNutclusterInstances() {
        Set<NutclusterInstance> result = SetUtil.createHashSet(INSTANCE_MAP.size());
        for (InstanceFuture f : INSTANCE_MAP.values()) {
            result.add((NutclusterInstance)f.get());
        }
        return result;
    }

    public static NutclusterInstance getNutclusterInstance(String instanceName) {
        InstanceFuture instanceFuture = (InstanceFuture)INSTANCE_MAP.get(instanceName);
        if (instanceFuture == null) {
            return null;
        }
        try {
            return (NutclusterInstance)instanceFuture.get();
        }
        catch (IllegalStateException t) {
            return null;
        }
    }

    public static NutclusterInstance getOrCreateNutclusterInstance(Config config) {
        if (config == null) {
            config = new XmlConfigBuilder().build();
        }
        String name = config.getInstanceName();
        Preconditions.checkHasText(name, "instanceName must contain text");
        InstanceFuture<NutclusterInstanceProxy> future = (InstanceFuture<NutclusterInstanceProxy>)INSTANCE_MAP.get(name);
        if (future != null) {
            return (NutclusterInstance)future.get();
        }
        future = new InstanceFuture<NutclusterInstanceProxy>();
        InstanceFuture found = INSTANCE_MAP.putIfAbsent(name, future);
        if (found != null) {
            return (NutclusterInstance)found.get();
        }
        try {
            return NutclusterInstanceFactory.constructNutclusterInstance(config, name, new DefaultNodeContext(), future);
        }
        catch (Throwable t) {
            INSTANCE_MAP.remove(name, future);
            future.setFailure(t);
            throw ExceptionUtil.rethrow(t);
        }
    }

    public static NutclusterInstance newNutclusterInstance(Config config) {
        return NutclusterInstanceFactory.newNutclusterInstance(config, new DefaultNodeContext());
    }

    public static NutclusterInstance newNutclusterInstance(Config config, NodeContext nodeContext) {
        if (config == null) {
            config = Config.load();
        }
        return NutclusterInstanceFactory.newNutclusterInstance(config, config.getInstanceName(), nodeContext);
    }

    public static String createInstanceName(Config config) {
        return "_ncInstance_" + FACTORY_ID_GEN.incrementAndGet() + "_" + config.getGroupConfig().getName();
    }

    public static String getInstanceName(String instanceName, Config config) {
        String name = instanceName;
        if (name == null || name.trim().length() == 0) {
            name = NutclusterInstanceFactory.createInstanceName(config);
        }
        return name;
    }

    public static NutclusterInstance newNutclusterInstance(Config config, String instanceName, NodeContext nodeContext) {
        InstanceFuture<NutclusterInstanceProxy> future;
        String name;
        if (config == null) {
            config = new XmlConfigBuilder().build();
        }
        if (INSTANCE_MAP.putIfAbsent(name = NutclusterInstanceFactory.getInstanceName(instanceName, config), future = new InstanceFuture<NutclusterInstanceProxy>()) != null) {
            throw new DuplicateInstanceNameException("NutclusterInstance with name '" + name + "' already exists!");
        }
        try {
            return NutclusterInstanceFactory.constructNutclusterInstance(config, name, nodeContext, future);
        }
        catch (Throwable t) {
            INSTANCE_MAP.remove(name, future);
            future.setFailure(t);
            throw ExceptionUtil.rethrow(t);
        }
    }

    private static NutclusterInstanceProxy newNutclusterProxy(NutclusterInstanceImpl NutclusterInstance2) {
        return new NutclusterInstanceProxy(NutclusterInstance2);
    }

    private static NutclusterInstanceProxy constructNutclusterInstance(Config config, String instanceName, NodeContext nodeContext, InstanceFuture<NutclusterInstanceProxy> future) {
        NutclusterInstanceProxy proxy;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            if (classLoader == null) {
                Thread.currentThread().setContextClassLoader(NutclusterInstanceFactory.class.getClassLoader());
            }
            NutclusterInstanceImpl NutclusterInstance2 = new NutclusterInstanceImpl(instanceName, config, nodeContext);
            OutOfMemoryErrorDispatcher.registerServer(NutclusterInstance2);
            proxy = NutclusterInstanceFactory.newNutclusterProxy(NutclusterInstance2);
            Node node = NutclusterInstance2.node;
            boolean firstMember = NutclusterInstanceFactory.isFirstMember(node);
            long initialWaitSeconds = node.getProperties().getSeconds(GroupProperty.INITIAL_WAIT_SECONDS);
            if (initialWaitSeconds > 0L) {
                NutclusterInstance2.logger.info(String.format("Waiting %d seconds before completing NutclusterInstance startup...", initialWaitSeconds));
                try {
                    TimeUnit.SECONDS.sleep(initialWaitSeconds);
                    if (firstMember) {
                        node.partitionService.firstArrangement();
                    } else {
                        TimeUnit.SECONDS.sleep(4L);
                    }
                }
                catch (InterruptedException ignored) {
                    Thread.currentThread().interrupt();
                }
            }
            NutclusterInstanceFactory.awaitMinimalClusterSize(NutclusterInstance2, node, firstMember);
            future.set(proxy);
            NutclusterInstance2.lifecycleService.fireLifecycleEvent(LifecycleEvent.LifecycleState.STARTED);
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
        return proxy;
    }

    private static boolean isFirstMember(Node node) {
        Iterator<Member> iterator = node.getClusterService().getMembers().iterator();
        return iterator.hasNext() && iterator.next().localMember();
    }

    private static void awaitMinimalClusterSize(NutclusterInstanceImpl NutclusterInstance2, Node node, boolean firstMember) throws InterruptedException {
        int initialMinClusterSize = node.getProperties().getInteger(GroupProperty.INITIAL_MIN_CLUSTER_SIZE);
        while (node.getClusterService().getSize() < initialMinClusterSize) {
            try {
                NutclusterInstance2.logger.info("NutclusterInstance waiting for cluster size of " + initialMinClusterSize);
                TimeUnit.SECONDS.sleep(1L);
            }
            catch (InterruptedException ignored) {
                Thread.currentThread().interrupt();
            }
        }
        if (initialMinClusterSize > 1) {
            if (firstMember) {
                node.partitionService.firstArrangement();
            } else {
                TimeUnit.SECONDS.sleep(3L);
            }
            NutclusterInstance2.logger.info("NutclusterInstance starting after waiting for cluster size of " + initialMinClusterSize);
        }
    }

    public static void shutdownAll() {
        NutclusterInstanceFactory.shutdownAll(false);
    }

    public static void terminateAll() {
        NutclusterInstanceFactory.shutdownAll(true);
    }

    private static void shutdownAll(boolean terminate) {
        LinkedList<NutclusterInstanceProxy> instances = new LinkedList<NutclusterInstanceProxy>();
        for (InstanceFuture future : INSTANCE_MAP.values()) {
            try {
                NutclusterInstanceProxy instanceProxy = (NutclusterInstanceProxy)future.get();
                instances.add(instanceProxy);
            }
            catch (RuntimeException ignored) {
                EmptyStatement.ignore(ignored);
            }
        }
        INSTANCE_MAP.clear();
        OutOfMemoryErrorDispatcher.clearServers();
        ManagementService.shutdownAll(instances);
        Collections.sort(instances, new Comparator<NutclusterInstanceProxy>(){

            @Override
            public int compare(NutclusterInstanceProxy o1, NutclusterInstanceProxy o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        for (NutclusterInstanceProxy proxy : instances) {
            if (terminate) {
                proxy.getLifecycleService().terminate();
            } else {
                proxy.getLifecycleService().shutdown();
            }
            proxy.original = null;
        }
    }

    public static void remove(NutclusterInstanceImpl instance) {
        OutOfMemoryErrorDispatcher.deregisterServer(instance);
        InstanceFuture future = (InstanceFuture)INSTANCE_MAP.remove(instance.getName());
        if (future != null && future.isSet()) {
            ((NutclusterInstanceProxy)future.get()).original = null;
        }
        if (INSTANCE_MAP.size() == 0) {
            ManagementService.shutdown(instance.getName());
        }
    }

    static {
        ModularJavaUtils.checkJavaInternalAccess(Logger.getLogger(NutclusterInstanceFactory.class));
    }

    public static class InstanceFuture<T> {
        private volatile T hz;
        private volatile Throwable throwable;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public T get() {
            if (this.hz != null) {
                return this.hz;
            }
            boolean restoreInterrupt = false;
            InstanceFuture instanceFuture = this;
            synchronized (instanceFuture) {
                while (this.hz == null && this.throwable == null) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException ignored) {
                        restoreInterrupt = true;
                    }
                }
            }
            if (restoreInterrupt) {
                Thread.currentThread().interrupt();
            }
            if (this.hz != null) {
                return this.hz;
            }
            throw new IllegalStateException(this.throwable);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void set(T proxy) {
            InstanceFuture instanceFuture = this;
            synchronized (instanceFuture) {
                this.hz = proxy;
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setFailure(Throwable throwable) {
            InstanceFuture instanceFuture = this;
            synchronized (instanceFuture) {
                this.throwable = throwable;
                this.notifyAll();
            }
        }

        public boolean isSet() {
            return this.hz != null;
        }
    }
}

