/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.internal.ascii.memcache;

import com.atlassian.nutcluster.core.NutclusterException;
import com.atlassian.nutcluster.internal.ascii.TextCommandConstants;
import com.atlassian.nutcluster.internal.ascii.TextCommandServiceImpl;
import com.atlassian.nutcluster.internal.ascii.memcache.MemcacheCommandProcessor;
import com.atlassian.nutcluster.internal.ascii.memcache.TouchCommand;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;

public class TouchCommandProcessor
extends MemcacheCommandProcessor<TouchCommand> {
    public TouchCommandProcessor(TextCommandServiceImpl textCommandService) {
        super(textCommandService);
    }

    @Override
    public void handle(TouchCommand touchCommand) {
        String key;
        try {
            key = URLDecoder.decode(touchCommand.getKey(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new NutclusterException(e);
        }
        Object mapName = "hz_memcache_default";
        int index = key.indexOf(58);
        if (index != -1) {
            mapName = "hz_memcache_" + key.substring(0, index);
            key = key.substring(index + 1);
        }
        int ttl = this.textCommandService.getAdjustedTTLSeconds(touchCommand.getExpiration());
        try {
            this.textCommandService.lock((String)mapName, key);
        }
        catch (Exception e) {
            touchCommand.setResponse(TextCommandConstants.NOT_STORED);
            if (touchCommand.shouldReply()) {
                this.textCommandService.sendResponse(touchCommand);
            }
            return;
        }
        Object value = this.textCommandService.get((String)mapName, key);
        this.textCommandService.incrementTouchCount();
        if (value != null) {
            this.textCommandService.put((String)mapName, key, value, ttl);
            touchCommand.setResponse(TextCommandConstants.TOUCHED);
        } else {
            touchCommand.setResponse(TextCommandConstants.NOT_STORED);
        }
        this.textCommandService.unlock((String)mapName, key);
        if (touchCommand.shouldReply()) {
            this.textCommandService.sendResponse(touchCommand);
        }
    }

    @Override
    public void handleRejection(TouchCommand request) {
        request.setResponse(TextCommandConstants.NOT_STORED);
        if (request.shouldReply()) {
            this.textCommandService.sendResponse(request);
        }
    }
}

