/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.internal.cluster.impl.operations;

import com.atlassian.nutcluster.core.MemberLeftException;
import com.atlassian.nutcluster.internal.cluster.impl.ClusterServiceImpl;
import com.atlassian.nutcluster.internal.cluster.impl.ClusterStateChange;
import com.atlassian.nutcluster.internal.cluster.impl.ClusterStateManager;
import com.atlassian.nutcluster.nio.Address;
import com.atlassian.nutcluster.nio.ObjectDataInput;
import com.atlassian.nutcluster.nio.ObjectDataOutput;
import com.atlassian.nutcluster.nio.serialization.IdentifiedDataSerializable;
import com.atlassian.nutcluster.spi.ExceptionAction;
import com.atlassian.nutcluster.spi.Operation;
import com.atlassian.nutcluster.spi.UrgentSystemOperation;
import com.atlassian.nutcluster.spi.exception.TargetNotMemberException;
import com.atlassian.nutcluster.spi.impl.AllowedDuringPassiveState;
import com.atlassian.nutcluster.transaction.TransactionException;
import java.io.IOException;

public class CommitClusterStateOp
extends Operation
implements AllowedDuringPassiveState,
UrgentSystemOperation,
IdentifiedDataSerializable {
    private ClusterStateChange stateChange;
    private Address initiator;
    private String txnId;
    private boolean isTransient;

    public CommitClusterStateOp() {
    }

    public CommitClusterStateOp(ClusterStateChange stateChange, Address initiator, String txnId, boolean isTransient) {
        this.stateChange = stateChange;
        this.initiator = initiator;
        this.txnId = txnId;
        this.isTransient = isTransient;
    }

    @Override
    public void beforeRun() throws Exception {
        if (this.stateChange == null) {
            throw new IllegalArgumentException("Invalid null cluster state");
        }
        this.stateChange.validate();
    }

    @Override
    public void run() throws Exception {
        ClusterServiceImpl service = (ClusterServiceImpl)this.getService();
        ClusterStateManager clusterStateManager = service.getClusterStateManager();
        this.getLogger().info(String.format("Changing cluster state from %s to %s, initiator: %s, transient: %s", clusterStateManager.stateToString(), this.stateChange, this.initiator, this.isTransient));
        clusterStateManager.commitClusterState(this.stateChange, this.initiator, this.txnId, this.isTransient);
    }

    @Override
    public void logError(Throwable e) {
        if (e instanceof TransactionException || e instanceof IllegalStateException) {
            this.getLogger().severe(e.getMessage());
        } else {
            super.logError(e);
        }
    }

    @Override
    public ExceptionAction onInvocationException(Throwable throwable) {
        if (throwable instanceof MemberLeftException || throwable instanceof TargetNotMemberException) {
            return ExceptionAction.THROW_EXCEPTION;
        }
        return super.onInvocationException(throwable);
    }

    @Override
    public Object getResponse() {
        return Boolean.TRUE;
    }

    @Override
    public String getServiceName() {
        return "hz:core:clusterService";
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeObject(this.stateChange);
        this.initiator.writeData(out);
        out.writeUTF(this.txnId);
        out.writeBoolean(this.isTransient);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.stateChange = (ClusterStateChange)in.readObject();
        this.initiator = new Address();
        this.initiator.readData(in);
        this.txnId = in.readUTF();
        this.isTransient = in.readBoolean();
    }

    @Override
    public int getFactoryId() {
        return 0;
    }

    @Override
    public int getId() {
        return 10;
    }
}

