/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.internal.cluster.impl.operations;

import com.atlassian.nutcluster.core.MemberLeftException;
import com.atlassian.nutcluster.internal.cluster.impl.ClusterServiceImpl;
import com.atlassian.nutcluster.internal.cluster.impl.ClusterStateManager;
import com.atlassian.nutcluster.nio.Address;
import com.atlassian.nutcluster.nio.ObjectDataInput;
import com.atlassian.nutcluster.nio.ObjectDataOutput;
import com.atlassian.nutcluster.nio.serialization.IdentifiedDataSerializable;
import com.atlassian.nutcluster.spi.ExceptionAction;
import com.atlassian.nutcluster.spi.Operation;
import com.atlassian.nutcluster.spi.UrgentSystemOperation;
import com.atlassian.nutcluster.spi.exception.TargetNotMemberException;
import com.atlassian.nutcluster.spi.impl.AllowedDuringPassiveState;
import java.io.IOException;

public class RollbackClusterStateOp
extends Operation
implements AllowedDuringPassiveState,
UrgentSystemOperation,
IdentifiedDataSerializable {
    private Address initiator;
    private String txnId;
    private boolean response;

    public RollbackClusterStateOp() {
    }

    public RollbackClusterStateOp(Address initiator, String txnId) {
        this.initiator = initiator;
        this.txnId = txnId;
    }

    @Override
    public void run() throws Exception {
        ClusterServiceImpl service = (ClusterServiceImpl)this.getService();
        ClusterStateManager clusterStateManager = service.getClusterStateManager();
        this.getLogger().info("Rolling back cluster state! Initiator: " + String.valueOf(this.initiator));
        this.response = clusterStateManager.rollbackClusterState(this.txnId);
    }

    @Override
    public Object getResponse() {
        return this.response;
    }

    @Override
    public String getServiceName() {
        return "hz:core:clusterService";
    }

    @Override
    public ExceptionAction onInvocationException(Throwable throwable) {
        if (throwable instanceof MemberLeftException || throwable instanceof TargetNotMemberException) {
            return ExceptionAction.THROW_EXCEPTION;
        }
        return super.onInvocationException(throwable);
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        this.initiator.writeData(out);
        out.writeUTF(this.txnId);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.initiator = new Address();
        this.initiator.readData(in);
        this.txnId = in.readUTF();
    }

    @Override
    public int getFactoryId() {
        return 0;
    }

    @Override
    public int getId() {
        return 23;
    }
}

