/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.internal.cluster.impl.operations;

import com.atlassian.nutcluster.cluster.ClusterState;
import com.atlassian.nutcluster.instance.Node;
import com.atlassian.nutcluster.internal.cluster.impl.ClusterServiceImpl;
import com.atlassian.nutcluster.internal.cluster.impl.operations.AbstractClusterOperation;
import com.atlassian.nutcluster.logging.ILogger;
import com.atlassian.nutcluster.spi.impl.AllowedDuringPassiveState;
import com.atlassian.nutcluster.spi.impl.NodeEngineImpl;
import com.atlassian.nutcluster.util.ThreadUtil;

public class ShutdownNodeOp
extends AbstractClusterOperation
implements AllowedDuringPassiveState {
    @Override
    public void run() {
        ClusterServiceImpl clusterService = (ClusterServiceImpl)this.getService();
        ILogger logger = this.getLogger();
        ClusterState clusterState = clusterService.getClusterState();
        if (clusterState == ClusterState.PASSIVE) {
            final NodeEngineImpl nodeEngine = (NodeEngineImpl)this.getNodeEngine();
            if (nodeEngine.isRunning()) {
                logger.info("Shutting down node in cluster passive state. Requested by: " + String.valueOf(this.getCallerAddress()));
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        Node node = nodeEngine.getNode();
                        node.nutclusterInstance.getLifecycleService().shutdown();
                    }
                }, ThreadUtil.createThreadName(nodeEngine.getNutclusterInstance().getName(), ".clusterShutdown")).start();
            } else {
                logger.info("Node is already shutting down. NodeState: " + String.valueOf((Object)nodeEngine.getNode().getState()));
            }
        } else {
            logger.severe("Can not shut down node because cluster is in " + String.valueOf((Object)clusterState) + " state. Requested by: " + String.valueOf(this.getCallerAddress()));
        }
    }

    @Override
    public int getId() {
        return 25;
    }
}

