/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.internal.diagnostics;

import com.atlassian.nutcluster.core.Member;
import com.atlassian.nutcluster.instance.NodeState;
import com.atlassian.nutcluster.internal.diagnostics.DiagnosticsLogWriter;
import com.atlassian.nutcluster.internal.diagnostics.DiagnosticsPlugin;
import com.atlassian.nutcluster.nio.Address;
import com.atlassian.nutcluster.spi.impl.NodeEngineImpl;
import com.atlassian.nutcluster.spi.properties.NutclusterProperty;
import java.util.concurrent.TimeUnit;

public class MemberNutclusterInstanceInfoPlugin
extends DiagnosticsPlugin {
    public static final NutclusterProperty PERIOD_SECONDS = new NutclusterProperty("hazelcast.diagnostics.memberinfo.period.seconds", 60, TimeUnit.SECONDS);
    private final long periodMillis;
    private final NodeEngineImpl nodeEngine;

    public MemberNutclusterInstanceInfoPlugin(NodeEngineImpl nodeEngine) {
        super(nodeEngine.getLogger(MemberNutclusterInstanceInfoPlugin.class));
        this.periodMillis = nodeEngine.getProperties().getMillis(PERIOD_SECONDS);
        this.nodeEngine = nodeEngine;
    }

    @Override
    public long getPeriodMillis() {
        return this.periodMillis;
    }

    @Override
    public void onStart() {
        this.logger.info("Plugin:active, period-millis:" + this.periodMillis);
    }

    @Override
    public void run(DiagnosticsLogWriter writer) {
        writer.startSection("NutclusterInstance");
        writer.writeKeyValueEntry("thisAddress", this.nodeEngine.getNode().getThisAddress().toString());
        writer.writeKeyValueEntry("isRunning", this.nodeEngine.getNode().isRunning());
        writer.writeKeyValueEntry("isLite", this.nodeEngine.getNode().isLiteMember());
        writer.writeKeyValueEntry("joined", this.nodeEngine.getNode().getClusterService().isJoined());
        NodeState state = this.nodeEngine.getNode().getState();
        writer.writeKeyValueEntry("nodeState", state == null ? "null" : state.toString());
        writer.writeKeyValueEntry("clusterId", this.nodeEngine.getClusterService().getClusterId());
        writer.writeKeyValueEntry("clusterSize", this.nodeEngine.getClusterService().getSize());
        writer.writeKeyValueEntry("isMaster", this.nodeEngine.getClusterService().isMaster());
        Address masterAddress = this.nodeEngine.getClusterService().getMasterAddress();
        writer.writeKeyValueEntry("masterAddress", masterAddress == null ? "null" : masterAddress.toString());
        writer.startSection("Members");
        for (Member member : this.nodeEngine.getClusterService().getMemberImpls()) {
            writer.writeEntry(member.getAddress().toString());
        }
        writer.endSection();
        writer.endSection();
    }
}

