/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.internal.diagnostics;

import com.atlassian.nutcluster.internal.diagnostics.DiagnosticsLogWriter;
import com.atlassian.nutcluster.internal.diagnostics.DiagnosticsPlugin;
import com.atlassian.nutcluster.internal.management.dto.SlowOperationDTO;
import com.atlassian.nutcluster.internal.management.dto.SlowOperationInvocationDTO;
import com.atlassian.nutcluster.spi.impl.NodeEngineImpl;
import com.atlassian.nutcluster.spi.impl.operationservice.InternalOperationService;
import com.atlassian.nutcluster.spi.properties.GroupProperty;
import com.atlassian.nutcluster.spi.properties.NutclusterProperties;
import com.atlassian.nutcluster.spi.properties.NutclusterProperty;
import com.atlassian.nutcluster.util.StringUtil;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class SlowOperationPlugin
extends DiagnosticsPlugin {
    public static final NutclusterProperty PERIOD_SECONDS = new NutclusterProperty("hazelcast.diagnostics.slowoperations.period.seconds", 60, TimeUnit.SECONDS);
    private final InternalOperationService operationService;
    private final long periodMillis;

    public SlowOperationPlugin(NodeEngineImpl nodeEngine) {
        super(nodeEngine.getLogger(SlowOperationPlugin.class));
        this.operationService = nodeEngine.getOperationService();
        this.periodMillis = this.getPeriodMillis(nodeEngine);
    }

    private long getPeriodMillis(NodeEngineImpl nodeEngine) {
        NutclusterProperties props = nodeEngine.getProperties();
        if (!props.getBoolean(GroupProperty.SLOW_OPERATION_DETECTOR_ENABLED)) {
            return 0L;
        }
        return props.getMillis(PERIOD_SECONDS);
    }

    @Override
    public long getPeriodMillis() {
        return this.periodMillis;
    }

    @Override
    public void onStart() {
        this.logger.info("Plugin:active, period-millis:" + this.periodMillis);
    }

    @Override
    public void run(DiagnosticsLogWriter writer) {
        List<SlowOperationDTO> slowOperations = this.operationService.getSlowOperationDTOs();
        writer.startSection("SlowOperations");
        if (slowOperations.size() > 0) {
            for (SlowOperationDTO slowOperation : slowOperations) {
                this.render(writer, slowOperation);
            }
        }
        writer.endSection();
    }

    private void render(DiagnosticsLogWriter writer, SlowOperationDTO slowOperation) {
        writer.startSection(slowOperation.operation);
        writer.writeKeyValueEntry("invocations", slowOperation.totalInvocations);
        this.renderStackTrace(writer, slowOperation);
        this.renderInvocations(writer, slowOperation);
        writer.endSection();
    }

    private void renderInvocations(DiagnosticsLogWriter writer, SlowOperationDTO slowOperation) {
        writer.startSection("slowInvocations");
        for (SlowOperationInvocationDTO invocation : slowOperation.invocations) {
            writer.writeKeyValueEntry("startedAt", invocation.startedAt);
            writer.writeKeyValueEntryAsDateTime("started(date-time)", invocation.startedAt);
            writer.writeKeyValueEntry("duration(ms)", invocation.durationMs);
            writer.writeKeyValueEntry("operationDetails", invocation.operationDetails);
        }
        writer.endSection();
    }

    private void renderStackTrace(DiagnosticsLogWriter writer, SlowOperationDTO slowOperation) {
        String[] stackTraceLines;
        writer.startSection("stackTrace");
        for (String stackTraceLine : stackTraceLines = slowOperation.stackTrace.split(StringUtil.LINE_SEPARATOR)) {
            writer.writeEntry(stackTraceLine);
        }
        writer.endSection();
    }
}

