/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.internal.jmx;

import com.atlassian.nutcluster.config.Config;
import com.atlassian.nutcluster.config.ConfigAccessor;
import com.atlassian.nutcluster.core.Cluster;
import com.atlassian.nutcluster.core.Member;
import com.atlassian.nutcluster.core.NutclusterInstance;
import com.atlassian.nutcluster.instance.Node;
import com.atlassian.nutcluster.instance.NutclusterInstanceImpl;
import com.atlassian.nutcluster.internal.jmx.ClientEngineMBean;
import com.atlassian.nutcluster.internal.jmx.EventServiceMBean;
import com.atlassian.nutcluster.internal.jmx.ManagedAnnotation;
import com.atlassian.nutcluster.internal.jmx.ManagedDescription;
import com.atlassian.nutcluster.internal.jmx.ManagedExecutorServiceMBean;
import com.atlassian.nutcluster.internal.jmx.ManagementService;
import com.atlassian.nutcluster.internal.jmx.NetworkingServiceMBean;
import com.atlassian.nutcluster.internal.jmx.NodeMBean;
import com.atlassian.nutcluster.internal.jmx.NutclusterMBean;
import com.atlassian.nutcluster.internal.jmx.OperationServiceMBean;
import com.atlassian.nutcluster.internal.jmx.PartitionServiceMBean;
import com.atlassian.nutcluster.internal.jmx.ProxyServiceMBean;
import com.atlassian.nutcluster.internal.jmx.WanPublisherMBean;
import com.atlassian.nutcluster.monitor.LocalWanPublisherStats;
import com.atlassian.nutcluster.monitor.LocalWanStats;
import com.atlassian.nutcluster.spi.ExecutionService;
import com.atlassian.nutcluster.spi.impl.executionservice.InternalExecutionService;
import com.atlassian.nutcluster.spi.impl.operationservice.InternalOperationService;
import com.atlassian.nutcluster.util.MapUtil;
import com.atlassian.nutcluster.wan.WanReplicationService;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

@ManagedDescription(value="NutclusterInstance")
public class InstanceMBean
extends NutclusterMBean<NutclusterInstanceImpl> {
    private static final int INITIAL_CAPACITY = 3;
    final Config config;
    final Cluster cluster;
    private NodeMBean nodeMBean;
    private NetworkingServiceMBean networkingServiceMBean;
    private EventServiceMBean eventServiceMBean;
    private OperationServiceMBean operationServiceMBean;
    private ProxyServiceMBean proxyServiceMBean;
    private ClientEngineMBean clientEngineMBean;
    private ManagedExecutorServiceMBean systemExecutorMBean;
    private ManagedExecutorServiceMBean asyncExecutorMBean;
    private ManagedExecutorServiceMBean scheduledExecutorMBean;
    private ManagedExecutorServiceMBean clientExecutorMBean;
    private ManagedExecutorServiceMBean clientQueryExecutorMBean;
    private ManagedExecutorServiceMBean clientBlockingExecutorMBean;
    private ManagedExecutorServiceMBean queryExecutorMBean;
    private ManagedExecutorServiceMBean ioExecutorMBean;
    private ManagedExecutorServiceMBean offloadableExecutorMBean;
    private PartitionServiceMBean partitionServiceMBean;

    protected InstanceMBean(NutclusterInstanceImpl NutclusterInstance2, ManagementService managementService) {
        super(NutclusterInstance2, managementService);
        this.createProperties(NutclusterInstance2);
        this.config = NutclusterInstance2.getConfig();
        this.cluster = NutclusterInstance2.getCluster();
        Node node = NutclusterInstance2.node;
        InternalExecutionService executionService = node.nodeEngine.getExecutionService();
        InternalOperationService operationService = node.nodeEngine.getOperationService();
        this.createMBeans(NutclusterInstance2, managementService, node, executionService, operationService);
        this.registerMBeans();
        this.registerWanPublisherMBeans(node.nodeEngine.getWanReplicationService());
    }

    private void registerWanPublisherMBeans(WanReplicationService wanReplicationService) {
        Map wanStats = wanReplicationService.getStats();
        if (wanStats == null) {
            return;
        }
        for (Map.Entry replicationStatsEntry : wanStats.entrySet()) {
            String wanReplicationName = replicationStatsEntry.getKey();
            LocalWanStats localWanStats = (LocalWanStats)replicationStatsEntry.getValue();
            Map<String, LocalWanPublisherStats> publisherStats = localWanStats.getLocalWanPublisherStats();
            for (String targetGroupName : publisherStats.keySet()) {
                InstanceMBean.register(new WanPublisherMBean(wanReplicationService, wanReplicationName, targetGroupName, this.service));
            }
        }
    }

    private void createMBeans(NutclusterInstanceImpl NutclusterInstance2, ManagementService managementService, Node node, ExecutionService executionService, InternalOperationService operationService) {
        this.nodeMBean = new NodeMBean(NutclusterInstance2, node, managementService);
        this.networkingServiceMBean = new NetworkingServiceMBean(NutclusterInstance2, node.networkingService, this.service);
        this.eventServiceMBean = new EventServiceMBean(NutclusterInstance2, node.nodeEngine.getEventService(), this.service);
        this.operationServiceMBean = new OperationServiceMBean(NutclusterInstance2, operationService, this.service);
        this.proxyServiceMBean = new ProxyServiceMBean(NutclusterInstance2, node.nodeEngine.getProxyService(), this.service);
        this.partitionServiceMBean = new PartitionServiceMBean(NutclusterInstance2, node.partitionService, this.service);
        this.clientEngineMBean = new ClientEngineMBean(NutclusterInstance2, node.clientEngine, this.service);
        this.systemExecutorMBean = new ManagedExecutorServiceMBean(NutclusterInstance2, executionService.getExecutor("hz:system"), this.service);
        this.asyncExecutorMBean = new ManagedExecutorServiceMBean(NutclusterInstance2, executionService.getExecutor("hz:async"), this.service);
        this.scheduledExecutorMBean = new ManagedExecutorServiceMBean(NutclusterInstance2, executionService.getExecutor("hz:scheduled"), this.service);
        this.clientExecutorMBean = new ManagedExecutorServiceMBean(NutclusterInstance2, executionService.getExecutor("hz:client"), this.service);
        this.clientQueryExecutorMBean = new ManagedExecutorServiceMBean(NutclusterInstance2, executionService.getExecutor("hz:client-query"), this.service);
        this.clientBlockingExecutorMBean = new ManagedExecutorServiceMBean(NutclusterInstance2, executionService.getExecutor("hz:client-blocking-tasks"), this.service);
        this.queryExecutorMBean = new ManagedExecutorServiceMBean(NutclusterInstance2, executionService.getExecutor("hz:query"), this.service);
        this.ioExecutorMBean = new ManagedExecutorServiceMBean(NutclusterInstance2, executionService.getExecutor("hz:io"), this.service);
        this.offloadableExecutorMBean = new ManagedExecutorServiceMBean(NutclusterInstance2, executionService.getExecutor("hz:offloadable"), this.service);
    }

    private void registerMBeans() {
        InstanceMBean.register(this.operationServiceMBean);
        InstanceMBean.register(this.nodeMBean);
        InstanceMBean.register(this.networkingServiceMBean);
        InstanceMBean.register(this.eventServiceMBean);
        InstanceMBean.register(this.proxyServiceMBean);
        InstanceMBean.register(this.partitionServiceMBean);
        InstanceMBean.register(this.clientEngineMBean);
        InstanceMBean.register(this.systemExecutorMBean);
        InstanceMBean.register(this.asyncExecutorMBean);
        InstanceMBean.register(this.scheduledExecutorMBean);
        InstanceMBean.register(this.clientExecutorMBean);
        InstanceMBean.register(this.clientQueryExecutorMBean);
        InstanceMBean.register(this.clientBlockingExecutorMBean);
        InstanceMBean.register(this.queryExecutorMBean);
        InstanceMBean.register(this.ioExecutorMBean);
        InstanceMBean.register(this.offloadableExecutorMBean);
    }

    private void createProperties(NutclusterInstanceImpl NutclusterInstance2) {
        Map<String, String> properties = MapUtil.createHashMap(3);
        properties.put("type", ManagementService.quote("NutclusterInstance"));
        properties.put("instance", ManagementService.quote(NutclusterInstance2.getName()));
        properties.put("name", ManagementService.quote(NutclusterInstance2.getName()));
        this.setObjectName(properties);
    }

    public PartitionServiceMBean getPartitionServiceMBean() {
        return this.partitionServiceMBean;
    }

    public ManagedExecutorServiceMBean getSystemExecutorMBean() {
        return this.systemExecutorMBean;
    }

    public ManagedExecutorServiceMBean getAsyncExecutorMBean() {
        return this.asyncExecutorMBean;
    }

    public ManagedExecutorServiceMBean getScheduledExecutorMBean() {
        return this.scheduledExecutorMBean;
    }

    public ManagedExecutorServiceMBean getClientExecutorMBean() {
        return this.clientExecutorMBean;
    }

    public ManagedExecutorServiceMBean getClientQueryExecutorMBean() {
        return this.clientQueryExecutorMBean;
    }

    public ManagedExecutorServiceMBean getClientBlockingExecutorMBean() {
        return this.clientBlockingExecutorMBean;
    }

    public ManagedExecutorServiceMBean getQueryExecutorMBean() {
        return this.queryExecutorMBean;
    }

    public ManagedExecutorServiceMBean getIoExecutorMBean() {
        return this.ioExecutorMBean;
    }

    public ManagedExecutorServiceMBean getOffloadableExecutorMBean() {
        return this.offloadableExecutorMBean;
    }

    public OperationServiceMBean getOperationServiceMBean() {
        return this.operationServiceMBean;
    }

    public ProxyServiceMBean getProxyServiceMBean() {
        return this.proxyServiceMBean;
    }

    public ClientEngineMBean getClientEngineMBean() {
        return this.clientEngineMBean;
    }

    public NetworkingServiceMBean getNetworkingServiceMBean() {
        return this.networkingServiceMBean;
    }

    public EventServiceMBean getEventServiceMBean() {
        return this.eventServiceMBean;
    }

    public NodeMBean getNodeMBean() {
        return this.nodeMBean;
    }

    public NutclusterInstance getNutclusterInstance() {
        return (NutclusterInstance)this.managedObject;
    }

    @ManagedAnnotation(value="name")
    @ManagedDescription(value="Name of the Instance")
    public String getName() {
        return ((NutclusterInstanceImpl)this.managedObject).getName();
    }

    @ManagedAnnotation(value="version")
    @ManagedDescription(value="The Nutcluster version")
    public String getVersion() {
        return ((NutclusterInstanceImpl)this.managedObject).node.getBuildInfo().getVersion();
    }

    @ManagedAnnotation(value="build")
    @ManagedDescription(value="The Nutcluster build")
    public String getBuild() {
        return ((NutclusterInstanceImpl)this.managedObject).node.getBuildInfo().getBuild();
    }

    @ManagedAnnotation(value="config")
    @ManagedDescription(value="String representation of config")
    public String getConfig() {
        return this.config.toString();
    }

    @ManagedAnnotation(value="configSource")
    @ManagedDescription(value="The source of config")
    public String getConfigSource() {
        File configurationFile = this.config.getConfigurationFile();
        if (configurationFile != null) {
            return configurationFile.getAbsolutePath();
        }
        URL configurationUrl = this.config.getConfigurationUrl();
        if (configurationUrl != null) {
            return configurationUrl.toString();
        }
        return null;
    }

    @ManagedAnnotation(value="groupName")
    @ManagedDescription(value="Group Name")
    public String getGroupName() {
        return this.config.getGroupConfig().getName();
    }

    @ManagedAnnotation(value="port")
    @ManagedDescription(value="Network Port")
    public int getPort() {
        return ConfigAccessor.getActiveMemberNetworkConfig(this.config).getPort();
    }

    @ManagedAnnotation(value="clusterTime")
    @ManagedDescription(value="Cluster-wide Time")
    public long getClusterTime() {
        return this.cluster.getClusterTime();
    }

    @ManagedAnnotation(value="memberCount")
    @ManagedDescription(value="size of the cluster")
    public int getMemberCount() {
        return this.cluster.getMembers().size();
    }

    @ManagedAnnotation(value="Members")
    @ManagedDescription(value="List of Members")
    public List<String> getMembers() {
        Set<Member> members = this.cluster.getMembers();
        ArrayList<String> list = new ArrayList<String>(members.size());
        for (Member member : members) {
            list.add(member.getSocketAddress().toString());
        }
        return list;
    }

    @ManagedAnnotation(value="running")
    @ManagedDescription(value="Running state")
    public boolean isRunning() {
        return ((NutclusterInstanceImpl)this.managedObject).getLifecycleService().isRunning();
    }

    @ManagedAnnotation(value="shutdown", operation=true)
    @ManagedDescription(value="Shutdown the Node")
    public void shutdown() {
        ((NutclusterInstanceImpl)this.managedObject).getLifecycleService().shutdown();
    }
}

