/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.internal.jmx;

import com.atlassian.nutcluster.core.DistributedObject;
import com.atlassian.nutcluster.core.IAtomicLong;
import com.atlassian.nutcluster.core.IAtomicReference;
import com.atlassian.nutcluster.core.ICountDownLatch;
import com.atlassian.nutcluster.core.IExecutorService;
import com.atlassian.nutcluster.core.IList;
import com.atlassian.nutcluster.core.ILock;
import com.atlassian.nutcluster.core.IMap;
import com.atlassian.nutcluster.core.IQueue;
import com.atlassian.nutcluster.core.ISemaphore;
import com.atlassian.nutcluster.core.ISet;
import com.atlassian.nutcluster.core.ITopic;
import com.atlassian.nutcluster.core.MultiMap;
import com.atlassian.nutcluster.internal.jmx.AtomicLongMBean;
import com.atlassian.nutcluster.internal.jmx.AtomicReferenceMBean;
import com.atlassian.nutcluster.internal.jmx.CountDownLatchMBean;
import com.atlassian.nutcluster.internal.jmx.ExecutorServiceMBean;
import com.atlassian.nutcluster.internal.jmx.ListMBean;
import com.atlassian.nutcluster.internal.jmx.LockMBean;
import com.atlassian.nutcluster.internal.jmx.ManagementService;
import com.atlassian.nutcluster.internal.jmx.MapMBean;
import com.atlassian.nutcluster.internal.jmx.MultiMapMBean;
import com.atlassian.nutcluster.internal.jmx.NutclusterMBean;
import com.atlassian.nutcluster.internal.jmx.QueueMBean;
import com.atlassian.nutcluster.internal.jmx.ReliableTopicMBean;
import com.atlassian.nutcluster.internal.jmx.ReplicatedMapMBean;
import com.atlassian.nutcluster.internal.jmx.SemaphoreMBean;
import com.atlassian.nutcluster.internal.jmx.SetMBean;
import com.atlassian.nutcluster.internal.jmx.TopicMBean;
import com.atlassian.nutcluster.replicatedmap.impl.ReplicatedMapProxy;
import com.atlassian.nutcluster.topic.impl.reliable.ReliableTopicProxy;
import com.atlassian.nutcluster.util.MapUtil;
import java.util.concurrent.ConcurrentMap;

final class MBeans {
    private static final ConcurrentMap<String, MBeanFactory> MBEAN_FACTORY_TYPES_REGISTRY;

    private MBeans() {
    }

    static NutclusterMBean createNutclusterMBeanOrNull(DistributedObject distributedObject, ManagementService managementService) {
        MBeanFactory mBeanFactory = MBeans.getMBeanFactory(distributedObject.getServiceName());
        return mBeanFactory == null ? null : mBeanFactory.createNew(distributedObject, managementService);
    }

    static String getObjectTypeOrNull(String serviceName) {
        MBeanFactory mBeanFactory = MBeans.getMBeanFactory(serviceName);
        return mBeanFactory == null ? null : mBeanFactory.getObjectType();
    }

    private static MBeanFactory getMBeanFactory(String serviceName) {
        return (MBeanFactory)((Object)MBEAN_FACTORY_TYPES_REGISTRY.get(serviceName));
    }

    static {
        MBeanFactory[] mBeanFactories;
        MBEAN_FACTORY_TYPES_REGISTRY = MapUtil.createConcurrentHashMap(MBeanFactory.values().length);
        for (MBeanFactory mBeanFactory : mBeanFactories = MBeanFactory.values()) {
            MBEAN_FACTORY_TYPES_REGISTRY.put(mBeanFactory.getServiceName(), mBeanFactory);
        }
    }

    static enum MBeanFactory {
        MAP{

            @Override
            public NutclusterMBean createNew(DistributedObject distributedObject, ManagementService managementService) {
                return new MapMBean((IMap)distributedObject, managementService);
            }

            @Override
            public String getObjectType() {
                return "IMap";
            }

            @Override
            public String getServiceName() {
                return "hz:impl:mapService";
            }
        }
        ,
        LIST{

            @Override
            public NutclusterMBean createNew(DistributedObject distributedObject, ManagementService managementService) {
                return new ListMBean((IList)distributedObject, managementService);
            }

            @Override
            public String getObjectType() {
                return "IList";
            }

            @Override
            public String getServiceName() {
                return "hz:impl:listService";
            }
        }
        ,
        ATOMIC_LONG{

            @Override
            public NutclusterMBean createNew(DistributedObject distributedObject, ManagementService managementService) {
                return new AtomicLongMBean((IAtomicLong)distributedObject, managementService);
            }

            @Override
            public String getObjectType() {
                return "IAtomicLong";
            }

            @Override
            public String getServiceName() {
                return "hz:impl:atomicLongService";
            }
        }
        ,
        ATOMIC_REFERENCE{

            @Override
            public NutclusterMBean createNew(DistributedObject distributedObject, ManagementService managementService) {
                return new AtomicReferenceMBean((IAtomicReference)distributedObject, managementService);
            }

            @Override
            public String getObjectType() {
                return "IAtomicReference";
            }

            @Override
            public String getServiceName() {
                return "hz:impl:atomicReferenceService";
            }
        }
        ,
        COUNT_DOWN_LATCH{

            @Override
            public NutclusterMBean createNew(DistributedObject distributedObject, ManagementService managementService) {
                return new CountDownLatchMBean((ICountDownLatch)distributedObject, managementService);
            }

            @Override
            public String getObjectType() {
                return "ICountDownLatch";
            }

            @Override
            public String getServiceName() {
                return "hz:impl:countDownLatchService";
            }
        }
        ,
        LOCK{

            @Override
            public NutclusterMBean createNew(DistributedObject distributedObject, ManagementService managementService) {
                return new LockMBean((ILock)distributedObject, managementService);
            }

            @Override
            public String getObjectType() {
                return "ILock";
            }

            @Override
            public String getServiceName() {
                return "hz:impl:lockService";
            }
        }
        ,
        MULTI_MAP{

            @Override
            public NutclusterMBean createNew(DistributedObject distributedObject, ManagementService managementService) {
                return new MultiMapMBean((MultiMap)distributedObject, managementService);
            }

            @Override
            public String getObjectType() {
                return "MultiMap";
            }

            @Override
            public String getServiceName() {
                return "hz:impl:multiMapService";
            }
        }
        ,
        QUEUE{

            @Override
            public NutclusterMBean createNew(DistributedObject distributedObject, ManagementService managementService) {
                return new QueueMBean((IQueue)distributedObject, managementService);
            }

            @Override
            public String getObjectType() {
                return "IQueue";
            }

            @Override
            public String getServiceName() {
                return "hz:impl:queueService";
            }
        }
        ,
        SEMAPHORE{

            @Override
            public NutclusterMBean createNew(DistributedObject distributedObject, ManagementService managementService) {
                return new SemaphoreMBean((ISemaphore)distributedObject, managementService);
            }

            @Override
            public String getObjectType() {
                return "ISemaphore";
            }

            @Override
            public String getServiceName() {
                return "hz:impl:semaphoreService";
            }
        }
        ,
        EXECUTOR_SERVICE{

            @Override
            public NutclusterMBean createNew(DistributedObject distributedObject, ManagementService managementService) {
                return new ExecutorServiceMBean((IExecutorService)distributedObject, managementService);
            }

            @Override
            public String getObjectType() {
                return "IExecutorService";
            }

            @Override
            public String getServiceName() {
                return "hz:impl:executorService";
            }
        }
        ,
        SET{

            @Override
            public NutclusterMBean createNew(DistributedObject distributedObject, ManagementService managementService) {
                return new SetMBean((ISet)distributedObject, managementService);
            }

            @Override
            public String getObjectType() {
                return "ISet";
            }

            @Override
            public String getServiceName() {
                return "hz:impl:setService";
            }
        }
        ,
        TOPIC{

            @Override
            public NutclusterMBean createNew(DistributedObject distributedObject, ManagementService managementService) {
                return new TopicMBean((ITopic)distributedObject, managementService);
            }

            @Override
            public String getObjectType() {
                return "ITopic";
            }

            @Override
            public String getServiceName() {
                return "hz:impl:topicService";
            }
        }
        ,
        REPLICATED_MAP{

            @Override
            public NutclusterMBean createNew(DistributedObject distributedObject, ManagementService managementService) {
                return new ReplicatedMapMBean((ReplicatedMapProxy)distributedObject, managementService);
            }

            @Override
            public String getObjectType() {
                return "ReplicatedMap";
            }

            @Override
            public String getServiceName() {
                return "hz:impl:replicatedMapService";
            }
        }
        ,
        RELIABLE_TOPIC{

            @Override
            public NutclusterMBean createNew(DistributedObject distributedObject, ManagementService managementService) {
                return new ReliableTopicMBean((ReliableTopicProxy)distributedObject, managementService);
            }

            @Override
            public String getObjectType() {
                return "ReliableTopic";
            }

            @Override
            public String getServiceName() {
                return "hz:impl:reliableTopicService";
            }
        };


        abstract NutclusterMBean createNew(DistributedObject var1, ManagementService var2);

        abstract String getObjectType();

        abstract String getServiceName();
    }
}

