/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.internal.jmx;

import com.atlassian.nutcluster.core.NutclusterInstance;
import com.atlassian.nutcluster.instance.EndpointQualifier;
import com.atlassian.nutcluster.internal.jmx.ManagedAnnotation;
import com.atlassian.nutcluster.internal.jmx.ManagedDescription;
import com.atlassian.nutcluster.internal.jmx.ManagementService;
import com.atlassian.nutcluster.internal.jmx.NutclusterMBean;
import com.atlassian.nutcluster.nio.EndpointManager;
import com.atlassian.nutcluster.nio.NetworkingService;
import com.atlassian.nutcluster.util.MapUtil;
import java.util.Map;

@ManagedDescription(value="NutclusterInstance.NetworkingService")
public class NetworkingServiceMBean
extends NutclusterMBean<NetworkingService> {
    private static final int PROPERTY_COUNT = 3;

    public NetworkingServiceMBean(NutclusterInstance NutclusterInstance2, NetworkingService ns, ManagementService service) {
        super(ns, service);
        Map<String, String> properties = MapUtil.createHashMap(3);
        properties.put("type", ManagementService.quote("NutclusterInstance.NetworkingService"));
        properties.put("instance", ManagementService.quote(NutclusterInstance2.getName()));
        properties.put("name", ManagementService.quote(NutclusterInstance2.getName()));
        this.setObjectName(properties);
    }

    public NetworkingService getNetworkingService() {
        return (NetworkingService)this.managedObject;
    }

    @ManagedAnnotation(value="clientConnectionCount")
    @ManagedDescription(value="Current number of client connections")
    public int getCurrentClientConnections() {
        EndpointManager cem = this.getNetworkingService().getEndpointManager(EndpointQualifier.CLIENT);
        if (cem == null) {
            return -1;
        }
        return cem.getActiveConnections().size();
    }

    @ManagedAnnotation(value="activeConnectionCount")
    @ManagedDescription(value="Current number of active connections")
    public int getActiveConnectionCount() {
        return this.getNetworkingService().getAggregateEndpointManager().getActiveConnections().size();
    }

    @ManagedAnnotation(value="connectionCount")
    @ManagedDescription(value="Current number of connections")
    public int getConnectionCount() {
        return this.getNetworkingService().getAggregateEndpointManager().getConnections().size();
    }
}

