/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.internal.jmx;

import com.atlassian.nutcluster.core.NutclusterInstance;
import com.atlassian.nutcluster.instance.Node;
import com.atlassian.nutcluster.internal.jmx.ManagedAnnotation;
import com.atlassian.nutcluster.internal.jmx.ManagedDescription;
import com.atlassian.nutcluster.internal.jmx.ManagementService;
import com.atlassian.nutcluster.internal.jmx.NutclusterMBean;
import com.atlassian.nutcluster.nio.Address;
import com.atlassian.nutcluster.util.MapUtil;
import java.util.Map;

@ManagedDescription(value="NutclusterInstance.Node")
public class NodeMBean
extends NutclusterMBean<Node> {
    private static final int INITIAL_CAPACITY = 3;

    public NodeMBean(NutclusterInstance NutclusterInstance2, Node node, ManagementService service) {
        super(node, service);
        Map<String, String> properties = MapUtil.createHashMap(3);
        properties.put("type", ManagementService.quote("NutclusterInstance.Node"));
        properties.put("name", ManagementService.quote("node" + String.valueOf(node.address)));
        properties.put("instance", ManagementService.quote(NutclusterInstance2.getName()));
        this.setObjectName(properties);
    }

    @ManagedAnnotation(value="address")
    @ManagedDescription(value="Address of the node")
    public String getName() {
        return ((Node)this.managedObject).address.toString();
    }

    @ManagedAnnotation(value="masterAddress")
    @ManagedDescription(value="The master address of the cluster")
    public String getMasterAddress() {
        Address masterAddress = ((Node)this.managedObject).getMasterAddress();
        return masterAddress == null ? null : masterAddress.toString();
    }
}

