/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.internal.jmx;

import com.atlassian.nutcluster.core.NutclusterInstance;
import com.atlassian.nutcluster.internal.jmx.ManagedAnnotation;
import com.atlassian.nutcluster.internal.jmx.ManagedDescription;
import com.atlassian.nutcluster.internal.jmx.ManagementService;
import com.atlassian.nutcluster.internal.jmx.NutclusterMBean;
import com.atlassian.nutcluster.spi.impl.operationservice.InternalOperationService;
import com.atlassian.nutcluster.util.MapUtil;
import java.util.Map;

@ManagedDescription(value="NutclusterInstance.OperationService")
public class OperationServiceMBean
extends NutclusterMBean<InternalOperationService> {
    private static final int INITIAL_CAPACITY = 3;

    public OperationServiceMBean(NutclusterInstance NutclusterInstance2, InternalOperationService operationService, ManagementService service) {
        super(operationService, service);
        Map<String, String> properties = MapUtil.createHashMap(3);
        properties.put("type", ManagementService.quote("NutclusterInstance.OperationService"));
        properties.put("name", ManagementService.quote("operationService" + NutclusterInstance2.getName()));
        properties.put("instance", ManagementService.quote(NutclusterInstance2.getName()));
        this.setObjectName(properties);
    }

    @ManagedAnnotation(value="responseQueueSize")
    @ManagedDescription(value="The size of the response queue")
    public int getResponseQueueSize() {
        return ((InternalOperationService)this.managedObject).getResponseQueueSize();
    }

    @ManagedAnnotation(value="operationExecutorQueueSize")
    @ManagedDescription(value="The size of the operation executor queue")
    public int getOperationExecutorQueueSize() {
        return ((InternalOperationService)this.managedObject).getOperationExecutorQueueSize();
    }

    @ManagedAnnotation(value="runningOperationsCount")
    @ManagedDescription(value="the running operations count")
    public int getRunningOperationsCount() {
        return ((InternalOperationService)this.managedObject).getRunningOperationsCount();
    }

    @ManagedAnnotation(value="remoteOperationCount")
    @ManagedDescription(value="The number of remote operations")
    public int getRemoteOperationsCount() {
        return ((InternalOperationService)this.managedObject).getRemoteOperationsCount();
    }

    @ManagedAnnotation(value="executedOperationCount")
    @ManagedDescription(value="The number of executed operations")
    public long getExecutedOperationCount() {
        return ((InternalOperationService)this.managedObject).getExecutedOperationCount();
    }

    @ManagedAnnotation(value="operationThreadCount")
    @ManagedDescription(value="Number of threads executing operations")
    public long getOperationThreadCount() {
        return ((InternalOperationService)this.managedObject).getPartitionThreadCount();
    }
}

