/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.internal.jmx;

import com.atlassian.nutcluster.config.Config;
import com.atlassian.nutcluster.config.TopicConfig;
import com.atlassian.nutcluster.core.ITopic;
import com.atlassian.nutcluster.internal.jmx.ManagedAnnotation;
import com.atlassian.nutcluster.internal.jmx.ManagedDescription;
import com.atlassian.nutcluster.internal.jmx.ManagementService;
import com.atlassian.nutcluster.internal.jmx.NutclusterMBean;

@ManagedDescription(value="ITopic")
public class TopicMBean
extends NutclusterMBean<ITopic> {
    protected TopicMBean(ITopic managedObject, ManagementService service) {
        super(managedObject, service);
        this.objectName = service.createObjectName("ITopic", managedObject.getName());
    }

    @ManagedAnnotation(value="localCreationTime")
    @ManagedDescription(value="the creation time of this topic on this member")
    public long getLocalCreationTime() {
        return ((ITopic)this.managedObject).getLocalTopicStats().getCreationTime();
    }

    @ManagedAnnotation(value="localPublishOperationCount")
    @ManagedDescription(value=" the total number of published messages of this topic on this member")
    public long getLocalPublishOperationCount() {
        return ((ITopic)this.managedObject).getLocalTopicStats().getPublishOperationCount();
    }

    @ManagedAnnotation(value="localReceiveOperationCount")
    @ManagedDescription(value="the total number of received messages of this topic on this member")
    public long getLocalReceiveOperationCount() {
        return ((ITopic)this.managedObject).getLocalTopicStats().getReceiveOperationCount();
    }

    @ManagedAnnotation(value="name")
    @ManagedDescription(value="Name of the DistributedObject")
    public String getName() {
        return ((ITopic)this.managedObject).getName();
    }

    @ManagedAnnotation(value="config")
    public String getConfig() {
        Config config = this.service.instance.getConfig();
        TopicConfig topicConfig = config.findTopicConfig(((ITopic)this.managedObject).getName());
        return topicConfig.toString();
    }
}

