/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.internal.management;

import com.atlassian.nutcluster.cache.CacheStatistics;
import com.atlassian.nutcluster.cache.impl.CacheService;
import com.atlassian.nutcluster.cache.impl.ICacheService;
import com.atlassian.nutcluster.collection.impl.queue.QueueService;
import com.atlassian.nutcluster.config.CacheConfig;
import com.atlassian.nutcluster.config.Config;
import com.atlassian.nutcluster.config.ConfigAccessor;
import com.atlassian.nutcluster.config.GroupConfig;
import com.atlassian.nutcluster.config.ManagementCenterConfig;
import com.atlassian.nutcluster.config.SSLConfig;
import com.atlassian.nutcluster.config.SocketInterceptorConfig;
import com.atlassian.nutcluster.core.Client;
import com.atlassian.nutcluster.core.Member;
import com.atlassian.nutcluster.cp.CPMember;
import com.atlassian.nutcluster.crdt.pncounter.PNCounterService;
import com.atlassian.nutcluster.executor.impl.DistributedExecutorService;
import com.atlassian.nutcluster.flakeidgen.impl.FlakeIdGeneratorService;
import com.atlassian.nutcluster.hotrestart.HotRestartService;
import com.atlassian.nutcluster.instance.MemberImpl;
import com.atlassian.nutcluster.instance.Node;
import com.atlassian.nutcluster.instance.NutclusterInstanceImpl;
import com.atlassian.nutcluster.internal.cluster.impl.ClusterServiceImpl;
import com.atlassian.nutcluster.internal.management.TimedMemberState;
import com.atlassian.nutcluster.internal.management.TimedMemberStateFactoryHelper;
import com.atlassian.nutcluster.internal.management.dto.AdvancedNetworkStatsDTO;
import com.atlassian.nutcluster.internal.management.dto.ClientEndPointDTO;
import com.atlassian.nutcluster.internal.management.dto.ClusterHotRestartStatusDTO;
import com.atlassian.nutcluster.internal.partition.InternalPartitionService;
import com.atlassian.nutcluster.map.impl.MapService;
import com.atlassian.nutcluster.monitor.LocalExecutorStats;
import com.atlassian.nutcluster.monitor.LocalFlakeIdGeneratorStats;
import com.atlassian.nutcluster.monitor.LocalMapStats;
import com.atlassian.nutcluster.monitor.LocalMemoryStats;
import com.atlassian.nutcluster.monitor.LocalMultiMapStats;
import com.atlassian.nutcluster.monitor.LocalOperationStats;
import com.atlassian.nutcluster.monitor.LocalPNCounterStats;
import com.atlassian.nutcluster.monitor.LocalQueueStats;
import com.atlassian.nutcluster.monitor.LocalReplicatedMapStats;
import com.atlassian.nutcluster.monitor.LocalTopicStats;
import com.atlassian.nutcluster.monitor.LocalWanStats;
import com.atlassian.nutcluster.monitor.WanSyncState;
import com.atlassian.nutcluster.monitor.impl.HotRestartStateImpl;
import com.atlassian.nutcluster.monitor.impl.LocalCacheStatsImpl;
import com.atlassian.nutcluster.monitor.impl.LocalMemoryStatsImpl;
import com.atlassian.nutcluster.monitor.impl.LocalOperationStatsImpl;
import com.atlassian.nutcluster.monitor.impl.MemberPartitionStateImpl;
import com.atlassian.nutcluster.monitor.impl.MemberStateImpl;
import com.atlassian.nutcluster.monitor.impl.NodeStateImpl;
import com.atlassian.nutcluster.multimap.impl.MultiMapService;
import com.atlassian.nutcluster.nio.Address;
import com.atlassian.nutcluster.nio.AggregateEndpointManager;
import com.atlassian.nutcluster.replicatedmap.impl.ReplicatedMapService;
import com.atlassian.nutcluster.spi.StatisticsAwareService;
import com.atlassian.nutcluster.spi.impl.NodeEngineImpl;
import com.atlassian.nutcluster.spi.impl.servicemanager.ServiceInfo;
import com.atlassian.nutcluster.spi.partition.IPartition;
import com.atlassian.nutcluster.topic.impl.TopicService;
import com.atlassian.nutcluster.topic.impl.reliable.ReliableTopicService;
import com.atlassian.nutcluster.util.EmptyStatement;
import com.atlassian.nutcluster.util.SetUtil;
import com.atlassian.nutcluster.wan.WanReplicationService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class TimedMemberStateFactory {
    private static final int INITIAL_PARTITION_SAFETY_CHECK_DELAY = 15;
    private static final int PARTITION_SAFETY_CHECK_PERIOD = 60;
    protected final NutclusterInstanceImpl instance;
    private final boolean cacheServiceEnabled;
    private volatile boolean memberStateSafe = true;

    public TimedMemberStateFactory(NutclusterInstanceImpl instance) {
        this.instance = instance;
        if (instance.node.getProperties().get("hazelcast.mc.max.visible.instance.count") != null) {
            instance.node.loggingService.getLogger(this.getClass()).warning("hazelcast.mc.max.visible.instance.count property is removed.");
        }
        this.cacheServiceEnabled = this.isCacheServiceEnabled();
    }

    private boolean isCacheServiceEnabled() {
        NodeEngineImpl nodeEngine = this.instance.node.nodeEngine;
        Collection<ServiceInfo> serviceInfos = nodeEngine.getServiceInfos(CacheService.class);
        return !serviceInfos.isEmpty();
    }

    public void init() {
        this.instance.node.nodeEngine.getExecutionService().scheduleWithRepetition(new Runnable(){

            @Override
            public void run() {
                TimedMemberStateFactory.this.memberStateSafe = TimedMemberStateFactory.this.instance.getPartitionService().isLocalMemberSafe();
            }
        }, 15L, 60L, TimeUnit.SECONDS);
    }

    public TimedMemberState createTimedMemberState() {
        MemberStateImpl memberState = new MemberStateImpl();
        Collection<StatisticsAwareService> services = this.instance.node.nodeEngine.getServices(StatisticsAwareService.class);
        TimedMemberState timedMemberState = new TimedMemberState();
        this.createMemberState(memberState, services);
        timedMemberState.setMaster(this.instance.node.isMaster());
        timedMemberState.setMemberList(new ArrayList<String>());
        Set<Member> memberSet = this.instance.getCluster().getMembers();
        for (Member member : memberSet) {
            MemberImpl memberImpl = (MemberImpl)member;
            Address address = memberImpl.getAddress();
            timedMemberState.getMemberList().add(address.getHost() + ":" + address.getPort());
        }
        timedMemberState.setMemberState(memberState);
        GroupConfig groupConfig = this.instance.getConfig().getGroupConfig();
        timedMemberState.setClusterName(groupConfig.getName());
        SSLConfig sslConfig = ConfigAccessor.getActiveMemberNetworkConfig(this.instance.getConfig()).getSSLConfig();
        timedMemberState.setSslEnabled(sslConfig != null && sslConfig.isEnabled());
        timedMemberState.setLite(this.instance.node.isLiteMember());
        SocketInterceptorConfig interceptorConfig = ConfigAccessor.getActiveMemberNetworkConfig(this.instance.getConfig()).getSocketInterceptorConfig();
        timedMemberState.setSocketInterceptorEnabled(interceptorConfig != null && interceptorConfig.isEnabled());
        ManagementCenterConfig managementCenterConfig = this.instance.node.getConfig().getManagementCenterConfig();
        timedMemberState.setScriptingEnabled(managementCenterConfig.isScriptingEnabled());
        return timedMemberState;
    }

    protected LocalMemoryStats getMemoryStats() {
        return new LocalMemoryStatsImpl(this.instance.getMemoryStats());
    }

    protected LocalOperationStats getOperationStats() {
        return new LocalOperationStatsImpl(this.instance.node);
    }

    private void createMemberState(MemberStateImpl memberState, Collection<StatisticsAwareService> services) {
        Node node = this.instance.node;
        Collection<Client> clients = this.instance.node.clientEngine.getClients();
        Set<ClientEndPointDTO> serializableClientEndPoints = SetUtil.createHashSet(clients.size());
        for (Client client : clients) {
            serializableClientEndPoints.add(new ClientEndPointDTO(client));
        }
        memberState.setClients(serializableClientEndPoints);
        memberState.setUuid(node.getThisUuid());
        memberState.setCpMemberUuid(this.getLocalCPMemberUuidSafely());
        Address thisAddress = node.getThisAddress();
        memberState.setAddress(thisAddress.getHost() + ":" + thisAddress.getPort());
        memberState.setEndpoints(node.getLocalMember().getAddressMap());
        TimedMemberStateFactoryHelper.registerJMXBeans(this.instance, memberState);
        MemberPartitionStateImpl memberPartitionState = (MemberPartitionStateImpl)memberState.getMemberPartitionState();
        InternalPartitionService partitionService = node.getPartitionService();
        IPartition[] partitions = partitionService.getPartitions();
        List<Integer> partitionList = memberPartitionState.getPartitions();
        for (IPartition partition : partitions) {
            if (!partition.isLocal()) continue;
            partitionList.add(partition.getPartitionId());
        }
        memberPartitionState.setMigrationQueueSize(partitionService.getMigrationQueueSize());
        memberPartitionState.setMemberStateSafe(this.memberStateSafe);
        memberState.setLocalMemoryStats(this.getMemoryStats());
        memberState.setOperationStats(this.getOperationStats());
        TimedMemberStateFactoryHelper.createRuntimeProps(memberState);
        this.createMemState(memberState, services);
        this.createNodeState(memberState);
        this.createHotRestartState(memberState);
        this.createClusterHotRestartStatus(memberState);
        this.createWanSyncState(memberState);
        memberState.setClientStats(node.clientEngine.getClientStatistics());
        AggregateEndpointManager aggregateEndpointManager = node.getNetworkingService().getAggregateEndpointManager();
        memberState.setInboundNetworkStats(new AdvancedNetworkStatsDTO(aggregateEndpointManager.getInboundNetworkStats()));
        memberState.setOutboundNetworkStats(new AdvancedNetworkStatsDTO(aggregateEndpointManager.getOutboundNetworkStats()));
    }

    private String getLocalCPMemberUuidSafely() {
        if (this.instance.getConfig().getCPSubsystemConfig().getCPMemberCount() == 0) {
            return null;
        }
        try {
            CPMember localCPMember = this.instance.getCPSubsystem().getLocalCPMember();
            return localCPMember != null ? localCPMember.getUuid() : null;
        }
        catch (UnsupportedOperationException e) {
            EmptyStatement.ignore(e);
            return null;
        }
    }

    private void createHotRestartState(MemberStateImpl memberState) {
        HotRestartService hotRestartService = this.instance.node.getNodeExtension().getHotRestartService();
        boolean hotBackupEnabled = hotRestartService.isHotBackupEnabled();
        String hotBackupDirectory = hotRestartService.getBackupDirectory();
        HotRestartStateImpl state = new HotRestartStateImpl(hotRestartService.getBackupTaskStatus(), hotBackupEnabled, hotBackupDirectory);
        memberState.setHotRestartState(state);
    }

    private void createClusterHotRestartStatus(MemberStateImpl memberState) {
        ClusterHotRestartStatusDTO state = this.instance.node.getNodeExtension().getInternalHotRestartService().getCurrentClusterHotRestartStatus();
        memberState.setClusterHotRestartStatus(state);
    }

    protected void createNodeState(MemberStateImpl memberState) {
        Node node = this.instance.node;
        ClusterServiceImpl cluster = this.instance.node.clusterService;
        NodeStateImpl nodeState = new NodeStateImpl(cluster.getClusterState(), node.getState(), cluster.getClusterVersion(), node.getVersion());
        memberState.setNodeState(nodeState);
    }

    private void createWanSyncState(MemberStateImpl memberState) {
        WanReplicationService wanReplicationService = this.instance.node.nodeEngine.getWanReplicationService();
        WanSyncState wanSyncState = wanReplicationService.getWanSyncState();
        if (wanSyncState != null) {
            memberState.setWanSyncState(wanSyncState);
        }
    }

    private void createMemState(MemberStateImpl memberState, Collection<StatisticsAwareService> services) {
        int count = 0;
        Config config = this.instance.getConfig();
        for (StatisticsAwareService service : services) {
            if (service instanceof MapService) {
                count = this.handleMap(memberState, count, config, ((MapService)service).getStats());
                continue;
            }
            if (service instanceof MultiMapService) {
                count = this.handleMultimap(memberState, count, config, ((MultiMapService)service).getStats());
                continue;
            }
            if (service instanceof QueueService) {
                count = this.handleQueue(memberState, count, config, ((QueueService)service).getStats());
                continue;
            }
            if (service instanceof TopicService) {
                count = this.handleTopic(memberState, count, config, ((TopicService)service).getStats());
                continue;
            }
            if (service instanceof ReliableTopicService) {
                count = this.handleReliableTopic(memberState, count, config, ((ReliableTopicService)service).getStats());
                continue;
            }
            if (service instanceof DistributedExecutorService) {
                count = this.handleExecutorService(memberState, count, config, ((DistributedExecutorService)service).getStats());
                continue;
            }
            if (service instanceof ReplicatedMapService) {
                count = this.handleReplicatedMap(memberState, count, config, ((ReplicatedMapService)service).getStats());
                continue;
            }
            if (service instanceof PNCounterService) {
                count = this.handlePNCounter(memberState, count, config, ((PNCounterService)service).getStats());
                continue;
            }
            if (!(service instanceof FlakeIdGeneratorService)) continue;
            count = this.handleFlakeIdGenerator(memberState, count, config, ((FlakeIdGeneratorService)service).getStats());
        }
        WanReplicationService wanReplicationService = this.instance.node.nodeEngine.getWanReplicationService();
        Map<String, LocalWanStats> wanStats = wanReplicationService.getStats();
        if (wanStats != null) {
            count = this.handleWan(memberState, count, wanStats);
        }
        if (this.cacheServiceEnabled) {
            ICacheService cacheService = this.getCacheService();
            for (CacheConfig cacheConfig : cacheService.getCacheConfigs()) {
                CacheStatistics statistics;
                if (!cacheConfig.isStatisticsEnabled() || (statistics = cacheService.getStatistics(cacheConfig.getNameWithPrefix())) == null) continue;
                count = this.handleCache(memberState, count, cacheConfig, statistics);
            }
        }
    }

    private int handleFlakeIdGenerator(MemberStateImpl memberState, int count, Config config, Map<String, LocalFlakeIdGeneratorStats> flakeIdstats) {
        for (Map.Entry<String, LocalFlakeIdGeneratorStats> entry : flakeIdstats.entrySet()) {
            String name = entry.getKey();
            if (!config.findFlakeIdGeneratorConfig(name).isStatisticsEnabled()) continue;
            LocalFlakeIdGeneratorStats stats = entry.getValue();
            memberState.putLocalFlakeIdStats(name, stats);
            ++count;
        }
        return count;
    }

    private int handleExecutorService(MemberStateImpl memberState, int count, Config config, Map<String, LocalExecutorStats> executorServices) {
        for (Map.Entry<String, LocalExecutorStats> entry : executorServices.entrySet()) {
            String name = entry.getKey();
            if (!config.findExecutorConfig(name).isStatisticsEnabled()) continue;
            LocalExecutorStats stats = entry.getValue();
            memberState.putLocalExecutorStats(name, stats);
            ++count;
        }
        return count;
    }

    private int handleMultimap(MemberStateImpl memberState, int count, Config config, Map<String, LocalMultiMapStats> multiMaps) {
        for (Map.Entry<String, LocalMultiMapStats> entry : multiMaps.entrySet()) {
            String name = entry.getKey();
            if (!config.findMultiMapConfig(name).isStatisticsEnabled()) continue;
            LocalMultiMapStats stats = entry.getValue();
            memberState.putLocalMultiMapStats(name, stats);
            ++count;
        }
        return count;
    }

    private int handleReplicatedMap(MemberStateImpl memberState, int count, Config config, Map<String, LocalReplicatedMapStats> replicatedMaps) {
        for (Map.Entry<String, LocalReplicatedMapStats> entry : replicatedMaps.entrySet()) {
            String name = entry.getKey();
            if (!config.findReplicatedMapConfig(name).isStatisticsEnabled()) continue;
            LocalReplicatedMapStats stats = entry.getValue();
            memberState.putLocalReplicatedMapStats(name, stats);
            ++count;
        }
        return count;
    }

    private int handlePNCounter(MemberStateImpl memberState, int count, Config config, Map<String, LocalPNCounterStats> counters) {
        for (Map.Entry<String, LocalPNCounterStats> entry : counters.entrySet()) {
            String name = entry.getKey();
            if (!config.findPNCounterConfig(name).isStatisticsEnabled()) continue;
            LocalPNCounterStats stats = entry.getValue();
            memberState.putLocalPNCounterStats(name, stats);
            ++count;
        }
        return count;
    }

    private int handleReliableTopic(MemberStateImpl memberState, int count, Config config, Map<String, LocalTopicStats> topics) {
        for (Map.Entry<String, LocalTopicStats> entry : topics.entrySet()) {
            String name = entry.getKey();
            if (!config.findReliableTopicConfig(name).isStatisticsEnabled()) continue;
            LocalTopicStats stats = entry.getValue();
            memberState.putLocalReliableTopicStats(name, stats);
            ++count;
        }
        return count;
    }

    private int handleTopic(MemberStateImpl memberState, int count, Config config, Map<String, LocalTopicStats> topics) {
        for (Map.Entry<String, LocalTopicStats> entry : topics.entrySet()) {
            String name = entry.getKey();
            if (!config.findTopicConfig(name).isStatisticsEnabled()) continue;
            LocalTopicStats stats = entry.getValue();
            memberState.putLocalTopicStats(name, stats);
            ++count;
        }
        return count;
    }

    private int handleQueue(MemberStateImpl memberState, int count, Config config, Map<String, LocalQueueStats> queues) {
        for (Map.Entry<String, LocalQueueStats> entry : queues.entrySet()) {
            String name = entry.getKey();
            if (!config.findQueueConfig(name).isStatisticsEnabled()) continue;
            LocalQueueStats stats = entry.getValue();
            memberState.putLocalQueueStats(name, stats);
            ++count;
        }
        return count;
    }

    private int handleMap(MemberStateImpl memberState, int count, Config config, Map<String, LocalMapStats> maps) {
        for (Map.Entry<String, LocalMapStats> entry : maps.entrySet()) {
            String name = entry.getKey();
            if (!config.findMapConfig(name).isStatisticsEnabled()) continue;
            LocalMapStats stats = entry.getValue();
            memberState.putLocalMapStats(name, stats);
            ++count;
        }
        return count;
    }

    private int handleWan(MemberStateImpl memberState, int count, Map<String, LocalWanStats> wans) {
        for (Map.Entry<String, LocalWanStats> entry : wans.entrySet()) {
            String schemeName = entry.getKey();
            LocalWanStats stats = entry.getValue();
            memberState.putLocalWanStats(schemeName, stats);
            ++count;
        }
        return count;
    }

    private int handleCache(MemberStateImpl memberState, int count, CacheConfig config, CacheStatistics cacheStatistics) {
        memberState.putLocalCacheStats(config.getNameWithPrefix(), new LocalCacheStatsImpl(cacheStatistics));
        return ++count;
    }

    private ICacheService getCacheService() {
        return (ICacheService)this.instance.node.nodeEngine.getService("hz:impl:cacheService");
    }
}

