/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.internal.management.dto;

import com.atlassian.nutcluster.config.AliasedDiscoveryConfig;
import com.atlassian.nutcluster.config.AliasedDiscoveryConfigUtils;
import com.atlassian.nutcluster.internal.json.JsonObject;
import com.atlassian.nutcluster.internal.json.JsonValue;
import com.atlassian.nutcluster.internal.management.JsonSerializable;
import com.atlassian.nutcluster.util.JsonUtil;
import com.atlassian.nutcluster.util.MapUtil;
import java.util.Map;

public class AliasedDiscoveryConfigDTO
implements JsonSerializable {
    private String tag;
    private AliasedDiscoveryConfig config;

    public AliasedDiscoveryConfigDTO(String tag) {
        this.tag = tag;
    }

    public AliasedDiscoveryConfigDTO(AliasedDiscoveryConfig config) {
        this.config = config;
    }

    @Override
    public JsonObject toJson() {
        JsonObject root = new JsonObject().add("enabled", this.config.isEnabled()).add("usePublicIp", this.config.isUsePublicIp());
        if (!MapUtil.isNullOrEmpty(this.config.getProperties())) {
            root.add("properties", JsonUtil.toJsonObject(this.config.getProperties()));
        }
        return root;
    }

    @Override
    public void fromJson(JsonObject json) {
        JsonValue usePublicIp;
        this.config = AliasedDiscoveryConfigUtils.newConfigFor(this.tag);
        JsonValue enabled = json.get("enabled");
        if (enabled != null && !enabled.isNull()) {
            this.config.setEnabled(enabled.asBoolean());
        }
        if ((usePublicIp = json.get("usePublicIp")) != null && !usePublicIp.isNull()) {
            this.config.setUsePublicIp(usePublicIp.asBoolean());
        }
        Map<String, Comparable> properties = JsonUtil.fromJsonObject((JsonObject)json.get("properties"));
        for (Map.Entry<String, Comparable> property : properties.entrySet()) {
            this.config.setProperty(property.getKey(), (String)((Object)property.getValue()));
        }
    }

    public AliasedDiscoveryConfig getConfig() {
        return this.config;
    }
}

