/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.internal.management.dto;

import com.atlassian.nutcluster.instance.NutclusterInstanceImpl;
import com.atlassian.nutcluster.internal.json.JsonObject;
import com.atlassian.nutcluster.internal.management.JsonSerializable;
import com.atlassian.nutcluster.internal.partition.InternalPartitionService;
import com.atlassian.nutcluster.nio.Address;
import com.atlassian.nutcluster.util.JsonUtil;

public class PartitionServiceBeanDTO
implements JsonSerializable {
    private int partitionCount;
    private int activePartitionCount;

    public PartitionServiceBeanDTO() {
    }

    public PartitionServiceBeanDTO(InternalPartitionService partitionService, NutclusterInstanceImpl NutclusterInstance2) {
        Address address = NutclusterInstance2.getCluster().getLocalMember().getAddress();
        this.partitionCount = partitionService.getPartitionCount();
        this.activePartitionCount = partitionService.getMemberPartitionsIfAssigned(address).size();
    }

    public int getPartitionCount() {
        return this.partitionCount;
    }

    public void setPartitionCount(int partitionCount) {
        this.partitionCount = partitionCount;
    }

    public int getActivePartitionCount() {
        return this.activePartitionCount;
    }

    public void setActivePartitionCount(int activePartitionCount) {
        this.activePartitionCount = activePartitionCount;
    }

    @Override
    public JsonObject toJson() {
        JsonObject root = new JsonObject();
        root.add("partitionCount", this.partitionCount);
        root.add("activePartitionCount", this.activePartitionCount);
        return root;
    }

    @Override
    public void fromJson(JsonObject json) {
        this.partitionCount = JsonUtil.getInt(json, "partitionCount", -1);
        this.activePartitionCount = JsonUtil.getInt(json, "activePartitionCount", -1);
    }
}

